/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.to_server;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Optional;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.world.item.RoutingTableBookItem;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import mods.railcraft.world.item.component.RoutingTableBookContent;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record EditRoutingTableBookMessage(InteractionHand hand, List<String> pages, Optional<String> title) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EditRoutingTableBookMessage> TYPE = new CustomPacketPayload.Type(RailcraftConstants.rl("edit_routing_table_book"));
    public static final StreamCodec<FriendlyByteBuf, EditRoutingTableBookMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(InteractionHand.class), EditRoutingTableBookMessage::hand, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), EditRoutingTableBookMessage::pages, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), EditRoutingTableBookMessage::title, EditRoutingTableBookMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(EditRoutingTableBookMessage message, IPayloadContext context) {
        Player player = context.player();
        GameProfile senderProfile = player.getGameProfile();
        ItemStack itemStack = player.getItemInHand(message.hand);
        if (itemStack.getItem() instanceof RoutingTableBookItem) {
            itemStack.set(RailcraftDataComponents.ROUTING_TABLE_BOOK, (Object)new RoutingTableBookContent(message.pages, senderProfile.name(), message.title));
        }
    }
}

