/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.to_server;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.world.item.GoldenTicketItem;
import mods.railcraft.world.item.TicketItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.players.NameAndId;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record EditTicketMessage(InteractionHand hand, String dest) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EditTicketMessage> TYPE = new CustomPacketPayload.Type(RailcraftConstants.rl("edit_ticket"));
    public static final StreamCodec<FriendlyByteBuf, EditTicketMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(InteractionHand.class), EditTicketMessage::hand, (StreamCodec)ByteBufCodecs.STRING_UTF8, EditTicketMessage::dest, EditTicketMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(EditTicketMessage message, IPayloadContext context) {
        Player player = context.player();
        NameAndId senderProfile = player.nameAndId();
        ItemStack itemStackToUpdate = player.getItemInHand(message.hand);
        if (itemStackToUpdate.getItem() instanceof GoldenTicketItem) {
            TicketItem.setTicketData(itemStackToUpdate, message.dest, senderProfile);
        }
    }
}

