/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.to_server;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.world.level.block.entity.LockableSwitchTrackActuatorBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.players.NameAndId;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetRoutingTrackMessage(BlockPos blockPos, LockableSwitchTrackActuatorBlockEntity.Lock lock) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetRoutingTrackMessage> TYPE = new CustomPacketPayload.Type(RailcraftConstants.rl("set_routing_track"));
    public static final StreamCodec<FriendlyByteBuf, SetRoutingTrackMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SetRoutingTrackMessage::blockPos, (StreamCodec)NeoForgeStreamCodecs.enumCodec(LockableSwitchTrackActuatorBlockEntity.Lock.class), SetRoutingTrackMessage::lock, SetRoutingTrackMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SetRoutingTrackMessage message, IPayloadContext context) {
        Player player = context.player();
        Level level = player.level();
        NameAndId senderProfile = player.nameAndId();
        level.getBlockEntity(message.blockPos, (BlockEntityType)RailcraftBlockEntityTypes.ROUTING_TRACK.get()).filter(routingTrack -> routingTrack.canAccess(senderProfile)).ifPresent(routingTrack -> {
            routingTrack.setLock(message.lock.equals(LockableSwitchTrackActuatorBlockEntity.Lock.UNLOCKED) ? null : senderProfile);
            routingTrack.syncToClient();
            routingTrack.setChanged();
        });
    }
}

