/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import mods.railcraft.RailcraftConfig;
import mods.railcraft.datamaps.FluidHeat;
import mods.railcraft.datamaps.RailcraftDataMaps;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.fluid.FluidResource;

public final class FuelUtil {
    private FuelUtil() {
    }

    public static float getFuelValue(FluidResource fluidResource) {
        FluidHeat fluidHeat = (FluidHeat)fluidResource.getFluid().builtInRegistryHolder().getData(RailcraftDataMaps.FLUID_HEAT);
        if (fluidHeat == null) {
            return 0.0f;
        }
        float fuelMultiplier = ((Double)RailcraftConfig.SERVER.fuelMultiplier.get()).floatValue();
        return fuelMultiplier * (float)fluidHeat.heatValuePerBucket();
    }

    public static float getFuelValueForSize(FluidStack fluid) {
        return FuelUtil.getFuelValue(FluidResource.of((FluidStack)fluid)) * (float)fluid.getAmount() / 1000.0f;
    }
}

