/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import java.util.Optional;
import mods.railcraft.api.core.RailcraftFakePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.Nullable;

public class LevelUtil {
    @Nullable
    public static BlockEntity getBlockEntityWeak(Level level, BlockPos pos) {
        return level.isLoaded(pos) ? level.getBlockEntity(pos) : null;
    }

    public static Optional<BlockEntity> getBlockEntity(Level level, BlockPos pos) {
        return Optional.ofNullable(level.getBlockEntity(pos));
    }

    public static <T> Optional<T> getBlockEntity(BlockGetter getter, BlockPos pos, Class<T> blockEntityType) {
        return Optional.ofNullable(getter.getBlockEntity(pos)).filter(blockEntityType::isInstance).map(blockEntityType::cast);
    }

    public static boolean setBlockState(Level level, BlockPos pos, BlockState blockState, @Nullable Entity entity) {
        if (entity == null) {
            entity = RailcraftFakePlayer.get((ServerLevel)level, pos);
        }
        BlockSnapshot snapshot = BlockSnapshot.create((ResourceKey)level.dimension(), (LevelAccessor)level, (BlockPos)pos);
        boolean result = level.setBlockAndUpdate(pos, blockState);
        if (EventHooks.onBlockPlace((Entity)entity, (BlockSnapshot)snapshot, (Direction)Direction.UP)) {
            snapshot.restore(2);
            return false;
        }
        return result;
    }

    public static boolean setBlockStateWorldGen(Level level, BlockPos pos, BlockState blockState) {
        return level.setBlock(pos, blockState, 3);
    }

    public static boolean setAir(Level level, BlockPos pos) {
        return level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
    }

    public static boolean destroyBlock(ServerLevel level, BlockPos pos) {
        return level.destroyBlock(pos, level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS));
    }

    public static boolean destroyBlock(ServerLevel level, BlockPos pos, @Nullable Player actor) {
        return LevelUtil.destroyBlock((Level)level, pos, actor, level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS));
    }

    public static boolean destroyBlock(Level level, BlockPos pos, @Nullable Player actor, boolean dropBlock) {
        BlockEvent.BreakEvent event;
        if (actor == null) {
            actor = RailcraftFakePlayer.get((ServerLevel)level, pos);
        }
        if ((event = (BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(level, pos, level.getBlockState(pos), actor))).isCanceled()) {
            return false;
        }
        return level.destroyBlock(pos, dropBlock);
    }

    public static boolean playerRemoveBlock(ServerLevel level, BlockPos pos, @Nullable Player player) {
        return LevelUtil.playerRemoveBlock((Level)level, pos, player, level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS));
    }

    public static boolean playerRemoveBlock(Level level, BlockPos pos, @Nullable Player player, boolean dropBlock) {
        if (player == null) {
            player = RailcraftFakePlayer.get((ServerLevel)level, pos);
        }
        BlockState blockState = level.getBlockState(pos);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        BlockEvent.BreakEvent event = (BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(level, pos, blockState, player));
        if (event.isCanceled()) {
            return false;
        }
        if (!blockState.onDestroyedByPlayer(level, pos, player, player.getMainHandItem().copy(), dropBlock, level.getFluidState(pos))) {
            return false;
        }
        if (dropBlock) {
            blockState.getBlock().playerDestroy(level, player, pos, blockState, blockEntity, player.getMainHandItem());
        }
        return true;
    }

    public static void spewItem(ItemStack stack, Level level, double x, double y, double z) {
        if (stack.isEmpty()) {
            return;
        }
        float xOffset = level.random.nextFloat() * 0.8f + 0.1f;
        float yOffset = level.random.nextFloat() * 0.8f + 0.1f;
        float zOffset = level.random.nextFloat() * 0.8f + 0.1f;
        while (!stack.isEmpty()) {
            int numToDrop = Math.min(level.random.nextInt(21) + 10, stack.getCount());
            ItemStack newStack = stack.split(numToDrop);
            ItemEntity itemEntity = new ItemEntity(level, x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, newStack);
            level.addFreshEntity((Entity)itemEntity);
        }
    }
}

