/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import mods.railcraft.api.item.ActivationBlockingItem;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.util.ReflectionUtil;
import net.minecraft.server.players.NameAndId;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class PlayerUtil {
    public static boolean isOwnerOrOp(NameAndId owner, Player player) {
        return player.nameAndId().equals((Object)owner) || player.hasPermissions(2);
    }

    public static boolean doesItemBlockActivation(Player player, InteractionHand hand) {
        if (player.isShiftKeyDown() || hand == InteractionHand.OFF_HAND) {
            return true;
        }
        ItemStack heldItem = player.getItemInHand(hand);
        if (!heldItem.isEmpty()) {
            return TrackUtil.isRail(heldItem) || ReflectionUtil.isAnnotatedDeepSearch(ActivationBlockingItem.class, heldItem.getItem());
        }
        return false;
    }
}

