/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import mods.railcraft.RailcraftConfig;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RecipeUtil {
    public static <T> Optional<T> getPreferredElementByMod(Stream<T> list, Function<T, ResourceLocation> getName) {
        List mods = (List)RailcraftConfig.SERVER.preferredOres.get();
        return list.min(Comparator.comparingInt(t -> {
            ResourceLocation name = (ResourceLocation)getName.apply(t);
            String modId = name.getNamespace();
            int idx = mods.indexOf(modId);
            if (idx < 0) {
                return mods.size();
            }
            return idx;
        }).thenComparing(getName));
    }

    public static ItemStack getPreferredStackByMod(List<Holder<Item>> array) {
        return RecipeUtil.getPreferredElementByMod(array.stream().map(Holder::value), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)).map(ItemStack::new).orElseThrow(() -> new RuntimeException("Empty array?"));
    }
}

