/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public sealed interface VariantSet<K extends Enum<K>, R, V extends R> {
    public DeferredHolder<R, ? extends V> variantFor(K var1);

    public Collection<DeferredHolder<R, ? extends V>> variants();

    default public Stream<? extends V> boundVariants() {
        return this.variants().stream().map(DeferredHolder::get);
    }

    public void forEach(BiConsumer<K, DeferredHolder<R, ? extends V>> var1);

    public static <K extends Enum<K>, V extends Block> VariantSet<K, Block, V> of(Class<K> keyType, DeferredRegister.Blocks deferredRegister, String nameTemplate, BiFunction<BlockBehaviour.Properties, K, V> func, BlockBehaviour.Properties properties) {
        EnumMap<Enum, DeferredBlock> variants = new EnumMap<Enum, DeferredBlock>(keyType);
        for (Enum key : (Enum[])keyType.getEnumConstants()) {
            String name = String.format(nameTemplate, ((StringRepresentable)key).getSerializedName());
            variants.put(key, deferredRegister.registerBlock(name, p -> (Block)func.apply((BlockBehaviour.Properties)p, (Object)key), () -> properties));
        }
        return new MappedVariantSet(variants);
    }

    public static <K extends Enum<K>, V extends Block> VariantSet<K, Block, V> of(Class<K> keyType, DeferredRegister.Blocks deferredRegister, String nameTemplate, Function<BlockBehaviour.Properties, V> func, BlockBehaviour.Properties properties) {
        EnumMap<Enum, DeferredBlock> variants = new EnumMap<Enum, DeferredBlock>(keyType);
        for (Enum key : (Enum[])keyType.getEnumConstants()) {
            String name = String.format(nameTemplate, ((StringRepresentable)key).getSerializedName());
            variants.put(key, deferredRegister.registerBlock(name, func, () -> properties));
        }
        return new MappedVariantSet(variants);
    }

    public static <K extends Enum<K>, V extends Item, SR, SV extends SR> VariantSet<K, Item, V> ofMapped(Class<K> keyType, DeferredRegister.Items deferredRegister, VariantSet<K, SR, SV> source, BiFunction<Item.Properties, ? super SV, ? extends V> mapper) {
        EnumMap variants = new EnumMap(keyType);
        source.forEach((key, value) -> {
            String name = ((ResourceKey)value.unwrapKey().orElseThrow()).location().getPath();
            variants.put((Object)key, deferredRegister.registerItem(name, properties -> (Item)mapper.apply(properties.useBlockDescriptionPrefix(), (Object)value.get())));
        });
        return new MappedVariantSet(variants);
    }

    public record MappedVariantSet<K extends Enum<K>, R, V extends R>(Map<K, DeferredHolder<R, ? extends V>> variantsByKey) implements VariantSet<K, R, V>
    {
        public MappedVariantSet(Map<K, DeferredHolder<R, ? extends V>> variantsByKey) {
            this.variantsByKey = ImmutableMap.copyOf(variantsByKey);
        }

        @Override
        public DeferredHolder<R, ? extends V> variantFor(K key) {
            return this.variantsByKey.get(key);
        }

        @Override
        public Collection<DeferredHolder<R, ? extends V>> variants() {
            return this.variantsByKey.values();
        }

        @Override
        public void forEach(BiConsumer<K, DeferredHolder<R, ? extends V>> action) {
            this.variantsByKey.forEach(action);
        }
    }
}

