/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.container;

import java.util.List;
import java.util.stream.Stream;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.container.manipulator.ContainerSlotAccessor;
import mods.railcraft.api.container.manipulator.ModifiableSlotAccessor;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.module.ModuleProvider;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import org.jetbrains.annotations.Nullable;

public class AdvancedContainer
extends SimpleContainer
implements ContainerManipulator<ModifiableSlotAccessor>,
ValueIOSerializable {
    private final List<ModifiableSlotAccessor> slots;
    @Nullable
    private Listener listener;
    private int maxStackSize = 64;

    public AdvancedContainer(int size) {
        super(size);
        this.slots = ContainerSlotAccessor.createSlots((Container)this, 0, size).toList();
    }

    @Override
    public Stream<ModifiableSlotAccessor> stream() {
        return this.slots.stream();
    }

    public AdvancedContainer listener(Container container) {
        return this.listener(new ContainerCallback(container));
    }

    public AdvancedContainer listener(ModuleProvider moduleProvider) {
        return this.listener(new ModuleProviderCallback(moduleProvider));
    }

    public AdvancedContainer listener(RailcraftBlockEntity blockEntity) {
        return this.listener(new BlockEntityCallback(blockEntity));
    }

    public AdvancedContainer listener(Listener callback) {
        this.listener = callback;
        this.addListener(callback);
        return this;
    }

    public AdvancedContainer phantom() {
        this.maxStackSize = 127;
        return this;
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public boolean stillValid(Player player) {
        return this.listener == null || this.listener.stillValid(player);
    }

    public void startOpen(ContainerUser user) {
        if (this.listener != null) {
            this.listener.startOpen(user);
        }
    }

    public void stopOpen(ContainerUser user) {
        if (this.listener != null) {
            this.listener.stopOpen(user);
        }
    }

    public static AdvancedContainer copyOf(Container original) {
        AdvancedContainer copy = new AdvancedContainer(original.getContainerSize());
        for (int i = 0; i < original.getContainerSize(); ++i) {
            ItemStack itemStack = original.getItem(i);
            if (itemStack.isEmpty()) continue;
            copy.setItem(i, itemStack.copy());
        }
        return copy;
    }

    public void serialize(ValueOutput valueOutput) {
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, (NonNullList)this.getItems(), (boolean)false);
    }

    public void deserialize(ValueInput valueInput) {
        NonNullList tempItems = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)valueInput, (NonNullList)tempItems);
        for (int i = 0; i < tempItems.size(); ++i) {
            this.setItem(i, (ItemStack)tempItems.get(i));
        }
    }

    public static class ContainerCallback
    implements Listener {
        private final Container container;

        public ContainerCallback(Container container) {
            this.container = container;
        }

        @Override
        public boolean stillValid(Player player) {
            return this.container.stillValid(player);
        }

        @Override
        public void startOpen(ContainerUser user) {
            this.container.startOpen(user);
        }

        @Override
        public void stopOpen(ContainerUser user) {
            this.container.stopOpen(user);
        }

        public void containerChanged(Container container) {
            this.container.setChanged();
        }
    }

    public static interface Listener
    extends ContainerListener {
        default public boolean stillValid(Player player) {
            return true;
        }

        default public void startOpen(ContainerUser user) {
        }

        default public void stopOpen(ContainerUser user) {
        }
    }

    public static class ModuleProviderCallback
    implements Listener {
        private final ModuleProvider moduleProvider;

        public ModuleProviderCallback(ModuleProvider moduleProvider) {
            this.moduleProvider = moduleProvider;
        }

        @Override
        public boolean stillValid(Player player) {
            return this.moduleProvider.isStillValid(player);
        }

        public void containerChanged(Container container) {
            this.moduleProvider.save();
        }
    }

    public static class BlockEntityCallback
    implements Listener {
        private final RailcraftBlockEntity blockEntity;

        public BlockEntityCallback(RailcraftBlockEntity blockEntity) {
            this.blockEntity = blockEntity;
        }

        @Override
        public boolean stillValid(Player player) {
            return this.blockEntity.isStillValid(player);
        }

        public void containerChanged(Container container) {
            this.blockEntity.setChanged();
        }
    }
}

