/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.container;

import net.minecraft.world.Container;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class CombinedVanillaContainerWrapper
implements ResourceHandler<ItemResource> {
    private final ResourceHandler<ItemResource> inputInv;
    private final ResourceHandler<ItemResource> outputInv;

    public CombinedVanillaContainerWrapper(Container inputInv, Container outputInv) {
        this.inputInv = VanillaContainerWrapper.of((Container)inputInv);
        this.outputInv = VanillaContainerWrapper.of((Container)outputInv);
    }

    public int size() {
        return this.inputInv.size() + this.outputInv.size();
    }

    public ItemResource getResource(int index) {
        if (index < this.inputInv.size()) {
            return (ItemResource)this.inputInv.getResource(index);
        }
        return (ItemResource)this.outputInv.getResource(index - this.inputInv.size());
    }

    public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
        if (index >= this.inputInv.size()) {
            return 0;
        }
        return this.inputInv.insert(index, (Resource)resource, amount, transaction);
    }

    public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
        if (index < this.inputInv.size()) {
            return 0;
        }
        return this.outputInv.extract(index - this.inputInv.size(), (Resource)resource, amount, transaction);
    }

    public long getCapacityAsLong(int index, ItemResource resource) {
        if (index < this.inputInv.size()) {
            return this.inputInv.getCapacityAsLong(index, (Resource)resource);
        }
        return this.outputInv.getCapacityAsLong(index - this.inputInv.size(), (Resource)resource);
    }

    public long getAmountAsLong(int index) {
        if (index < this.inputInv.size()) {
            return this.inputInv.getAmountAsLong(index);
        }
        return this.outputInv.getAmountAsLong(index - this.inputInv.size());
    }

    public boolean isValid(int index, ItemResource resource) {
        if (index < this.inputInv.size()) {
            return this.inputInv.isValid(index, (Resource)resource);
        }
        return false;
    }
}

