/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.fluids;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.level.material.TankManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public final class FluidTools {
    public static final int BUCKET_FILL_TIME = 8;
    public static final int NETWORK_UPDATE_INTERVAL = 128;
    public static final int PROCESS_VOLUME = 4000;

    private FluidTools() {
    }

    public static Component toString(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return Component.literal((String)"Empty");
        }
        return Component.literal((String)(fluidStack.getAmount() + "x")).append(fluidStack.getHoverName());
    }

    public static boolean interactWithFluidHandler(Player player, InteractionHand hand, ResourceHandler<FluidResource> fluidHandler) {
        return player.level().isClientSide() ? FluidTools.isFluidHandler(player.getItemInHand(hand)) : FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, null, fluidHandler);
    }

    public static boolean isFluidHandler(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return ItemAccess.forStack((ItemStack)stack).getCapability(Capabilities.Fluid.ITEM) != null;
    }

    public static boolean isEmptyContainer(ItemStack stack) {
        ResourceHandler cap = (ResourceHandler)ItemAccess.forStack((ItemStack)stack).getCapability(Capabilities.Fluid.ITEM);
        if (cap == null) {
            return false;
        }
        for (int i = 0; i < cap.size(); ++i) {
            if (cap.getAmountAsLong(i) <= 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isRoomInContainer(ItemStack stack, Fluid fluid) {
        ResourceHandler cap = (ResourceHandler)ItemAccess.forStack((ItemStack)stack).getCapability(Capabilities.Fluid.ITEM);
        Objects.requireNonNull(cap);
        try (Transaction tx = Transaction.openRoot();){
            boolean bl = cap.insert((Resource)FluidResource.of((Fluid)fluid), Integer.MAX_VALUE, (TransactionContext)tx) > 0;
            return bl;
        }
    }

    public static boolean containsFluid(ItemStack stack, Fluid fluid) {
        ResourceHandler cap = (ResourceHandler)ItemAccess.forStack((ItemStack)stack).getCapability(Capabilities.Fluid.ITEM);
        Objects.requireNonNull(cap);
        for (int i = 0; i < cap.size(); ++i) {
            if (((FluidResource)cap.getResource(i)).is((Object)fluid)) continue;
            return false;
        }
        return true;
    }

    private static void sendToProcessing(Container container) {
        ContainerMapper.make(container, 0, 1).moveOneItemTo(ContainerMapper.make(container, 1, 1).ignoreItemChecks());
    }

    private static void sendToOutput(Container container) {
        ContainerMapper.make(container, 1, 1).moveOneItemTo(ContainerMapper.make(container, 2, 1).ignoreItemChecks());
    }

    private static ProcessState tryFill(Container container, StandardTank tank, ItemAccess itemAccess) {
        ResourceHandler cap = (ResourceHandler)itemAccess.getCapability(Capabilities.Fluid.ITEM);
        int moved = ResourceHandlerUtil.move((ResourceHandler)tank, (ResourceHandler)cap, (Predicate)Predicates.alwaysTrue(), (int)1000, null);
        if (moved == 0) {
            FluidTools.sendToOutput(container);
            return ProcessState.RESET;
        }
        ItemStack result = itemAccess.getResource().toStack(itemAccess.getAmount());
        container.setItem(1, result);
        return ProcessState.FILLING;
    }

    private static ProcessState tryDrain(Container container, StandardTank tank, ItemAccess itemAccess) {
        ResourceHandler cap = (ResourceHandler)itemAccess.getCapability(Capabilities.Fluid.ITEM);
        int moved = ResourceHandlerUtil.move((ResourceHandler)cap, (ResourceHandler)tank, (Predicate)Predicates.alwaysTrue(), (int)1000, null);
        if (moved != 1000) {
            FluidTools.sendToOutput(container);
            return ProcessState.RESET;
        }
        container.setItem(1, itemAccess.getResource().toStack());
        return ProcessState.DRAINING;
    }

    public static ProcessState processContainer(Container container, StandardTank tank, ProcessType type, ProcessState state) {
        ItemStack itemStack = container.getItem(1);
        if (itemStack.isEmpty() || !FluidTools.isFluidHandler(itemStack)) {
            FluidTools.sendToProcessing(container);
            return ProcessState.RESET;
        }
        ItemAccess itemAccess = ItemAccess.forHandlerIndex((ResourceHandler)VanillaContainerWrapper.of((Container)container), (int)1);
        if (state == ProcessState.RESET) {
            if (type == ProcessType.FILL_ONLY) {
                return FluidTools.tryFill(container, tank, itemAccess);
            }
            if (type == ProcessType.DRAIN_ONLY) {
                return FluidTools.tryDrain(container, tank, itemAccess);
            }
            if (type == ProcessType.FILL_THEN_DRAIN) {
                ResourceHandler cap = (ResourceHandler)itemAccess.getCapability(Capabilities.Fluid.ITEM);
                if (ResourceHandlerUtil.move((ResourceHandler)tank, (ResourceHandler)cap, (Predicate)Predicates.alwaysTrue(), (int)1000, null) == 1000) {
                    return FluidTools.tryFill(container, tank, itemAccess);
                }
                return FluidTools.tryDrain(container, tank, itemAccess);
            }
            if (type == ProcessType.DRAIN_THEN_FILL) {
                if (!FluidUtil.getFirstStackContained((ItemStack)itemStack).isEmpty() && !tank.isFull()) {
                    return FluidTools.tryDrain(container, tank, itemAccess);
                }
                return FluidTools.tryFill(container, tank, itemAccess);
            }
        }
        if (state == ProcessState.FILLING) {
            return FluidTools.tryFill(container, tank, itemAccess);
        }
        if (state == ProcessState.DRAINING) {
            return FluidTools.tryDrain(container, tank, itemAccess);
        }
        return state;
    }

    public static boolean isFullFluidBlock(Level level, BlockPos pos) {
        return FluidTools.isFullFluidBlock(level.getBlockState(pos), level, pos);
    }

    public static boolean isFullFluidBlock(BlockState state, Level level, BlockPos pos) {
        if (state.getBlock() instanceof LiquidBlock) {
            return (Integer)state.getValue((Property)LiquidBlock.LEVEL) == 0;
        }
        return false;
    }

    public static Fluid getFluid(BlockState state) {
        return state.getFluidState().getType();
    }

    public static Collection<ResourceHandler<FluidResource>> findNeighbors(Level level, BlockPos centrePos, Predicate<BlockEntity> filter, Direction ... directions) {
        ArrayList<ResourceHandler<FluidResource>> targets = new ArrayList<ResourceHandler<FluidResource>>();
        for (Direction direction : directions) {
            ResourceHandler cap;
            BlockEntity blockEntity = level.getBlockEntity(centrePos.relative(direction));
            if (blockEntity == null || !TankManager.TANK_FILTER.apply(blockEntity, direction.getOpposite()).booleanValue() || !filter.test(blockEntity) || (cap = (ResourceHandler)level.getCapability(Capabilities.Fluid.BLOCK, blockEntity.getBlockPos(), (Object)direction.getOpposite())) == null) continue;
            targets.add((ResourceHandler<FluidResource>)cap);
        }
        return targets;
    }

    public static enum ProcessState implements StringRepresentable
    {
        FILLING("filling"),
        DRAINING("draining"),
        RESET("reset");

        public static final StringRepresentable.EnumCodec<ProcessState> CODEC;
        private final String name;

        private ProcessState(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ProcessState::values);
        }
    }

    public static enum ProcessType {
        FILL_ONLY,
        DRAIN_ONLY,
        FILL_THEN_DRAIN,
        DRAIN_THEN_FILL;

    }
}

