/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import java.util.List;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.MaintenanceMinecart;
import mods.railcraft.world.entity.vehicle.MaintenancePatternMinecart;
import mods.railcraft.world.inventory.TrackUndercutterMenu;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;

public class TrackUndercutter
extends MaintenancePatternMinecart {
    public static final int SLOT_STOCK_UNDER = 0;
    public static final int SLOT_STOCK_SIDE = 1;
    public static final int SLOT_EXIST_UNDER_A = 0;
    public static final int SLOT_EXIST_UNDER_B = 1;
    public static final int SLOT_EXIST_SIDE_A = 2;
    public static final int SLOT_EXIST_SIDE_B = 3;
    public static final int SLOT_REPLACE_UNDER = 4;
    public static final int SLOT_REPLACE_SIDE = 5;
    private static final int[] SLOTS = ContainerTools.buildSlotArray(0, 2);

    public TrackUndercutter(EntityType<?> type, Level level) {
        super(type, level);
    }

    public TrackUndercutter(ItemStack itemStack, Level level, double x, double y, double z) {
        super(itemStack, (EntityType)RailcraftEntityTypes.TRACK_UNDERCUTTER.get(), level, x, y, z);
    }

    @Override
    protected Item getDropItem() {
        return (Item)RailcraftItems.TRACK_UNDERCUTTER.get();
    }

    @Override
    public void tick() {
        BlockState blockState;
        super.tick();
        if (this.level().isClientSide()) {
            return;
        }
        if (this.mode() == MaintenanceMinecart.Mode.OFF) {
            return;
        }
        this.stockItems(4, 0);
        this.stockItems(5, 1);
        BlockPos pos = BlockPos.containing((Position)this.position());
        if (BaseRailBlock.isRail((Level)this.level(), (BlockPos)pos.below())) {
            pos = pos.below();
        }
        if (!BaseRailBlock.isRail((BlockState)(blockState = this.level().getBlockState(pos)))) {
            return;
        }
        RailShape railShape = TrackUtil.getTrackDirection((BlockGetter)this.level(), pos, blockState, (AbstractMinecart)this);
        pos = pos.below();
        boolean slotAEmpty = true;
        boolean slotBEmpty = true;
        if (!this.patternContainer.getItem(0).isEmpty()) {
            this.replaceUnder(pos, 0);
            slotAEmpty = false;
        }
        if (!this.patternContainer.getItem(1).isEmpty()) {
            this.replaceUnder(pos, 1);
            slotBEmpty = false;
        }
        if (slotAEmpty && slotBEmpty) {
            this.replaceUnder(pos, 0);
        }
        slotAEmpty = true;
        slotBEmpty = true;
        if (!this.patternContainer.getItem(2).isEmpty()) {
            this.replaceSide(pos, 2, railShape);
            slotAEmpty = false;
        }
        if (!this.patternContainer.getItem(3).isEmpty()) {
            this.replaceSide(pos, 3, railShape);
            slotBEmpty = false;
        }
        if (slotAEmpty && slotBEmpty) {
            this.replaceSide(pos, 2, railShape);
        }
    }

    private void replaceUnder(BlockPos pos, int slotExist) {
        this.replaceWith(pos, slotExist, 0);
    }

    private void replaceSide(BlockPos pos, int slotExist, RailShape railShape) {
        if (RailShapeUtil.isEastWest(railShape)) {
            this.replaceWith(pos.north(), slotExist, 1);
            this.replaceWith(pos.south(), slotExist, 1);
        } else if (RailShapeUtil.isNorthSouth(railShape)) {
            this.replaceWith(pos.east(), slotExist, 1);
            this.replaceWith(pos.west(), slotExist, 1);
        }
    }

    private void replaceWith(BlockPos pos, int existingSlot, int stockSlot) {
        ItemStack existingTrack = this.patternContainer.getItem(existingSlot);
        ItemStack stockTrack = this.getItem(stockSlot);
        if (!this.isValidBallast(stockTrack)) {
            return;
        }
        BlockState oldState = this.level().getBlockState(pos);
        if (!TrackUndercutter.blockMatches(oldState, existingTrack)) {
            return;
        }
        if (this.safeToReplace(pos)) {
            BlockState stockBlock = ContainerTools.getBlockStateFromStack(stockTrack, this.level(), pos);
            List drops = Block.getDrops((BlockState)oldState, (ServerLevel)((ServerLevel)this.level()), (BlockPos)pos, (BlockEntity)this.level().getBlockEntity(pos));
            if (stockBlock != null && this.level().setBlockAndUpdate(pos, stockBlock)) {
                this.level().playSound(null, pos, stockBlock.getSoundType().getPlaceSound(), SoundSource.AMBIENT, 1.0f, 0.8f);
                this.removeItem(stockSlot, 1);
                RollingStock rollingStock = RollingStock.getOrThrow((AbstractMinecart)this);
                for (ItemStack stack : drops) {
                    rollingStock.offerOrDropItem(stack);
                }
                this.blink();
            }
        }
    }

    private boolean safeToReplace(BlockPos pos) {
        BlockState blockState = this.level().getBlockState(pos);
        if (blockState.isAir()) {
            return false;
        }
        if (blockState.liquid()) {
            return false;
        }
        if (blockState.getDestroySpeed((BlockGetter)this.level(), pos) < 0.0f) {
            return false;
        }
        return !blockState.is(RailcraftTags.Blocks.TUNNEL_BORE_REPLACEABLE_BLOCKS);
    }

    public int[] getSlotsForFace(Direction side) {
        return SLOTS;
    }

    @Override
    public int getContainerSize() {
        return 2;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return switch (slot) {
            case 4 -> ItemStack.isSameItem((ItemStack)stack, (ItemStack)this.patternContainer.getItem(4));
            case 5 -> ItemStack.isSameItem((ItemStack)stack, (ItemStack)this.patternContainer.getItem(5));
            default -> false;
        };
    }

    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new TrackUndercutterMenu(id, inventory, this);
    }

    private static boolean blockMatches(BlockState state, ItemStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            return state.is(item2.getBlock()) || state.is(Blocks.GRASS_BLOCK) && item2.getBlock() == Blocks.DIRT;
        }
        return false;
    }

    public boolean isValidBallast(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        BlockState state = ContainerTools.getBlockStateFromStack(stack);
        if (state.is(RailcraftTags.Blocks.TRACK_UNDERCUTTER_INVALID_BALLAST)) {
            return false;
        }
        return state.isSuffocating((BlockGetter)this.level(), this.blockPosition());
    }
}

