/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.RailcraftMinecart;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.VoidChestBlock;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class VoidChestMinecart
extends RailcraftMinecart {
    private int tick;

    public VoidChestMinecart(EntityType<?> type, Level level) {
        super(type, level);
    }

    public VoidChestMinecart(ItemStack itemStack, Level level, double x, double y, double z) {
        super(itemStack, (EntityType)RailcraftEntityTypes.VOID_CHEST_MINECART.get(), level, x, y, z);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            return;
        }
        if (++this.tick >= 8) {
            this.clearContent();
            this.tick = 0;
        }
    }

    @Override
    protected Item getDropItem() {
        return (Item)RailcraftItems.VOID_CHEST_MINECART.get();
    }

    public int getContainerSize() {
        return 27;
    }

    public BlockState getDefaultDisplayBlockState() {
        return (BlockState)((VoidChestBlock)((Object)RailcraftBlocks.VOID_CHEST.get())).defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.NORTH);
    }

    public int getDefaultDisplayOffset() {
        return 8;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return ChestMenu.threeRows((int)id, (Inventory)playerInventory, (Container)this);
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        Level level;
        InteractionResult result = this.interactWithContainerVehicle(player);
        if (result.consumesAction() && (level = player.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            PiglinAi.angerNearbyPiglins((ServerLevel)level2, (Player)player, (boolean)true);
        }
        return result;
    }

    @Override
    public boolean canPassItemRequests(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canAcceptPushedItem(RollingStock requester, ItemStack stack) {
        return true;
    }

    @Override
    public boolean canProvidePulledItem(RollingStock requester, ItemStack stack) {
        return true;
    }
}

