/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import mods.railcraft.Railcraft;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.RailcraftMinecart;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.entity.worldspike.WorldSpikeBlockEntity;
import mods.railcraft.world.level.block.worldspike.WorldSpikeBlock;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class WorldSpikeMinecart
extends RailcraftMinecart {
    private static final Logger LOGGER = LogUtils.getLogger();
    private ChunkPos lastChunk;
    private final LongOpenHashSet chunkSet = new LongOpenHashSet();

    public WorldSpikeMinecart(EntityType<?> type, Level level) {
        super(type, level);
    }

    public WorldSpikeMinecart(ItemStack itemStack, Level level, double x, double y, double z) {
        super(itemStack, (EntityType)RailcraftEntityTypes.WORLD_SPIKE.get(), level, x, y, z);
    }

    @Override
    public boolean canPassItemRequests(ItemStack stack) {
        return true;
    }

    public BlockState getDefaultDisplayBlockState() {
        return ((WorldSpikeBlock)RailcraftBlocks.WORLD_SPIKE.get()).defaultBlockState();
    }

    public int getDefaultDisplayOffset() {
        return 6;
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            WorldSpikeBlockEntity.spawnParticle(serverLevel, this.getOnPos());
            if (!this.chunkPosition().equals((Object)this.lastChunk)) {
                LongOpenHashSet newChunkSet = new LongOpenHashSet();
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        ChunkPos loadChunk = new ChunkPos(this.chunkPosition().x + x, this.chunkPosition().z + z);
                        newChunkSet.add(loadChunk.toLong());
                        Railcraft.CHUNK_CONTROLLER.forceChunk(serverLevel, this.uuid, loadChunk.x, loadChunk.z, true, false);
                    }
                }
                boolean modified = this.chunkSet.removeAll((LongCollection)newChunkSet);
                if (modified) {
                    LongIterator longIterator = this.chunkSet.iterator();
                    while (longIterator.hasNext()) {
                        long chunkPos = (Long)longIterator.next();
                        int x = (int)chunkPos;
                        int z = (int)(chunkPos >> 32);
                        LOGGER.info("Unload chunk [X: {}, Z: {}]", (Object)x, (Object)z);
                        Railcraft.CHUNK_CONTROLLER.forceChunk(serverLevel, this.uuid, x, z, false, false);
                    }
                }
                this.chunkSet.clear();
                this.chunkSet.addAll((LongCollection)newChunkSet);
                this.lastChunk = this.chunkPosition();
                this.setChanged();
            }
        }
    }

    @Override
    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LOGGER.info("Minecart removed");
            level = this.chunkSet.iterator();
            while (level.hasNext()) {
                long chunkPos = (Long)level.next();
                int x = (int)chunkPos;
                int z = (int)(chunkPos >> 32);
                LOGGER.info("Unload chunk [X: {}, Z: {}]", (Object)x, (Object)z);
                Railcraft.CHUNK_CONTROLLER.forceChunk(serverLevel, this.uuid, x, z, false, false);
            }
        }
    }

    public int getContainerSize() {
        return 0;
    }

    @Override
    protected boolean hasMenu() {
        return false;
    }

    protected AbstractContainerMenu createMenu(int i, Inventory inventory) {
        return null;
    }

    @Override
    public Item getDropItem() {
        return (Item)RailcraftItems.WORLD_SPIKE_MINECART.get();
    }
}

