/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle.locomotive;

import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.carts.FluidTransferHandler;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.particle.RailcraftParticleTypes;
import mods.railcraft.season.Seasons;
import mods.railcraft.sounds.RailcraftSoundEvents;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.level.material.TankManager;
import mods.railcraft.world.level.material.steam.SteamBoiler;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public abstract class BaseSteamLocomotive
extends Locomotive
implements FluidTransferHandler {
    protected static final int SLOT_WATER_INPUT = 0;
    protected static final int SLOT_WATER_PROCESSING = 1;
    protected static final int SLOT_WATER_OUTPUT = 2;
    private static final EntityDataAccessor<Boolean> SMOKE = SynchedEntityData.defineId(BaseSteamLocomotive.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> STEAM = SynchedEntityData.defineId(BaseSteamLocomotive.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final byte TICKS_PER_BOILER_CYCLE = 2;
    private static final int FUEL_PER_REQUEST = 3;
    protected final StandardTank waterTank = StandardTank.ofBuckets(6).fillProcessor(originalState -> this.boiler.checkFill((FluidStack)originalState, this::explode)).filter((TagKey<Fluid>)FluidTags.WATER);
    protected final StandardTank steamTank = StandardTank.ofBuckets(16).filter(RailcraftTags.Fluids.STEAM).disableExtract().disableInsert();
    private final SteamBoiler boiler;
    protected final ContainerMapper invWaterContainers;
    private final TankManager tankManager;
    private int fluidProcessingTimer;
    private FluidTools.ProcessState processState;

    protected BaseSteamLocomotive(EntityType<?> type, Level level) {
        super(type, level);
        this.boiler = new SteamBoiler(this.waterTank, this.steamTank).setEfficiencyModifier((Double)RailcraftConfig.SERVER.fuelPerSteamMultiplier.get()).setTicksPerCycle(2);
        this.invWaterContainers = ContainerMapper.make((Container)this, 0, 3).ignoreItemChecks();
        this.tankManager = new TankManager(this.waterTank, this.steamTank);
        this.fluidProcessingTimer = 0;
        this.processState = FluidTools.ProcessState.RESET;
    }

    protected BaseSteamLocomotive(ItemStack itemStack, EntityType<?> type, Level level, double x, double y, double z) {
        super(itemStack, type, level, x, y, z);
        this.boiler = new SteamBoiler(this.waterTank, this.steamTank).setEfficiencyModifier((Double)RailcraftConfig.SERVER.fuelPerSteamMultiplier.get()).setTicksPerCycle(2);
        this.invWaterContainers = ContainerMapper.make((Container)this, 0, 3).ignoreItemChecks();
        this.tankManager = new TankManager(this.waterTank, this.steamTank);
        this.fluidProcessingTimer = 0;
        this.processState = FluidTools.ProcessState.RESET;
    }

    @Override
    public Locomotive.Speed getMaxReverseSpeed() {
        return Locomotive.Speed.SLOWEST;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SMOKE, (Object)false);
        builder.define(STEAM, (Object)false);
    }

    @Override
    public boolean isAllowedMode(Locomotive.Mode mode) {
        return this.waterTank.isEmpty() && mode == Locomotive.Mode.SHUTDOWN || super.isAllowedMode(mode);
    }

    @Override
    public SoundEvent getWhistleSound() {
        return (SoundEvent)RailcraftSoundEvents.STEAM_WHISTLE.get();
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        return FluidTools.interactWithFluidHandler(player, hand, this.getTankManager()) ? InteractionResult.SUCCESS : super.interact(player, hand);
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    protected void serverTick(ServerLevel level) {
        super.serverTick(level);
        if (this.waterTank.isEmpty()) {
            this.setMode(Locomotive.Mode.SHUTDOWN);
        }
        this.setSteaming(this.steamTank.getFluidAmount() > 0);
        if (this.steamTank.getRemainingSpace() >= 160 || this.isShutdown()) {
            this.boiler.tick((Level)level, 1);
            this.setSmoking(this.boiler.isBurning());
            if (!this.boiler.isBurning()) {
                this.ventSteam();
            }
        }
        if (++this.fluidProcessingTimer >= 8) {
            this.fluidProcessingTimer = 0;
            this.processState = FluidTools.processContainer(this.invWaterContainers, this.waterTank, FluidTools.ProcessType.DRAIN_ONLY, this.processState);
        }
    }

    @Override
    protected void clientTick(Level level) {
        float offset;
        super.clientTick(level);
        double rads = Math.toRadians(this.renderYaw);
        if (this.isSmoking()) {
            offset = 0.4f;
            double x = this.getX() - Math.cos(rads) * (double)offset;
            double y = this.getY() + 1.5;
            double z = this.getZ() - Math.sin(rads) * (double)offset;
            SimpleParticleType particle = Seasons.isHalloween() && this.random.nextInt(4) == 0 ? (SimpleParticleType)RailcraftParticleTypes.PUMPKIN.get() : ParticleTypes.CAMPFIRE_COSY_SMOKE;
            level.addParticle((ParticleOptions)particle, x, y, z, 0.0, 0.02, 0.0);
        }
        if (this.isSteaming()) {
            offset = 0.5f;
            double ninetyDeg = Math.toRadians(90.0) + Math.toRadians(this.random.nextInt(10));
            double steamAngularSpeed = 0.01;
            double yCoord = this.getY() + 0.15;
            double vx = steamAngularSpeed * Math.cos(rads - ninetyDeg);
            double vz = steamAngularSpeed * Math.sin(rads - ninetyDeg);
            level.addParticle((ParticleOptions)RailcraftParticleTypes.STEAM.get(), this.getX() - Math.cos(rads + ninetyDeg) * (double)offset, yCoord, this.getZ() - Math.sin(rads + ninetyDeg) * (double)offset, vx, 0.02 + this.random.nextDouble() * 0.01, vz);
            level.addParticle((ParticleOptions)RailcraftParticleTypes.STEAM.get(), this.getX() - Math.cos(rads - ninetyDeg) * (double)offset, yCoord, this.getZ() - Math.sin(rads - ninetyDeg) * (double)offset, vx, 0.02 + this.random.nextDouble() * 0.01, vz);
        }
    }

    public boolean isSmoking() {
        return (Boolean)this.entityData.get(SMOKE);
    }

    private void setSmoking(boolean smoke) {
        this.entityData.set(SMOKE, (Object)smoke);
    }

    public boolean isSteaming() {
        return (Boolean)this.entityData.get(STEAM);
    }

    private void setSteaming(boolean steam) {
        this.entityData.set(STEAM, (Object)steam);
    }

    private void ventSteam() {
        try (Transaction tx = Transaction.openRoot();){
            FluidResource resource = (FluidResource)this.steamTank.getResource(0);
            if (!resource.isEmpty()) {
                this.steamTank.internalExtract(resource, 4, (TransactionContext)tx);
                tx.commit();
            }
        }
    }

    public SteamBoiler boiler() {
        return this.boiler;
    }

    @Override
    public int retrieveFuel() {
        try (Transaction tx = Transaction.openRoot();){
            FluidStack steam = this.steamTank.getFluidStack();
            if (steam.isEmpty()) {
                int n = 0;
                return n;
            }
            if (steam.getAmount() >= this.steamTank.getCapacity() / 2) {
                this.steamTank.internalExtract(FluidResource.of((FluidStack)steam), 160, (TransactionContext)tx);
                tx.commit();
                int n = 3;
                return n;
            }
            int n = 0;
            return n;
        }
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putChild("tankManager", (ValueIOSerializable)this.tankManager);
        valueOutput.putChild("boiler", (ValueIOSerializable)this.boiler);
        valueOutput.store("processState", FluidTools.ProcessState.CODEC, (Object)this.processState);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        valueInput.readChild("tankManager", (ValueIOSerializable)this.tankManager);
        valueInput.readChild("boiler", (ValueIOSerializable)this.boiler);
        this.processState = valueInput.read("processState", FluidTools.ProcessState.CODEC).orElse(FluidTools.ProcessState.RESET);
    }

    public boolean isSafeToFill() {
        return !this.boiler.isSuperHeated() || !this.waterTank.isEmpty();
    }

    @Override
    public boolean canPassFluidRequests(FluidStack fluid) {
        return fluid.is(FluidTags.WATER);
    }

    @Override
    public boolean canAcceptPushedFluid(RollingStock requester, FluidStack fluid) {
        return fluid.is(FluidTags.WATER);
    }

    @Override
    public boolean canProvidePulledFluid(RollingStock requester, FluidStack fluid) {
        return false;
    }
}

