/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle.locomotive;

import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.Translations;
import mods.railcraft.advancements.KilledByLocomotiveTrigger;
import mods.railcraft.advancements.RailcraftCriteriaTriggers;
import mods.railcraft.api.carts.Linkable;
import mods.railcraft.api.carts.NeedsFuel;
import mods.railcraft.api.carts.Paintable;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.carts.Routable;
import mods.railcraft.api.core.Lockable;
import mods.railcraft.api.util.EnumUtil;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.SimpleTexturePosition;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.gui.button.ButtonState;
import mods.railcraft.network.RailcraftDataSerializers;
import mods.railcraft.season.Seasons;
import mods.railcraft.util.FunctionalUtil;
import mods.railcraft.util.MathUtil;
import mods.railcraft.util.ModEntitySelector;
import mods.railcraft.util.PlayerUtil;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.damagesource.RailcraftDamageSources;
import mods.railcraft.world.entity.vehicle.Directional;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.entity.vehicle.RailcraftMinecart;
import mods.railcraft.world.item.LocomotiveItem;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.TicketItem;
import mods.railcraft.world.item.component.LocomotiveColorComponent;
import mods.railcraft.world.item.component.LocomotiveLockComponent;
import mods.railcraft.world.item.component.LocomotiveOwnerComponent;
import mods.railcraft.world.item.component.LocomotiveWhistlePitchComponent;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public abstract class Locomotive
extends RailcraftMinecart
implements Linkable,
Directional,
Lockable,
Paintable,
Routable,
NeedsFuel {
    private static final EntityDataAccessor<Boolean> HAS_FUEL = SynchedEntityData.defineId(Locomotive.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Mode> MODE = SynchedEntityData.defineId(Locomotive.class, RailcraftDataSerializers.LOCOMOTIVE_MODE);
    private static final EntityDataAccessor<Speed> SPEED = SynchedEntityData.defineId(Locomotive.class, RailcraftDataSerializers.LOCOMOTIVE_SPEED);
    private static final EntityDataAccessor<Lock> LOCK = SynchedEntityData.defineId(Locomotive.class, RailcraftDataSerializers.LOCOMOTIVE_LOCK);
    private static final EntityDataAccessor<Boolean> REVERSE = SynchedEntityData.defineId(Locomotive.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> PRIMARY_COLOR = SynchedEntityData.defineId(Locomotive.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SECONDARY_COLOR = SynchedEntityData.defineId(Locomotive.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> DESTINATION = SynchedEntityData.defineId(Locomotive.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Optional<NameAndId>> OWNER = SynchedEntityData.defineId(Locomotive.class, RailcraftDataSerializers.OPTIONAL_NAME_AND_ID);
    private static final double DRAG_FACTOR = 0.9;
    private static final float HS_FORCE_BONUS = 3.5f;
    private static final byte FUEL_USE_INTERVAL = 8;
    private static final byte KNOCKBACK = 1;
    private static final int WHISTLE_INTERVAL = 256;
    private static final int WHISTLE_DELAY = 160;
    private static final int WHISTLE_CHANCE = 4;
    private static final Set<Mode> SUPPORTED_MODES = Collections.unmodifiableSet(EnumSet.allOf(Mode.class));
    protected float renderYaw;
    private int fuel;
    private int whistleDelay;
    private int tempIdle;
    private float whistlePitch = this.getNewWhistlePitch();

    protected Locomotive(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected Locomotive(ItemStack itemStack, EntityType<?> type, Level level, double x, double y, double z) {
        super(itemStack, type, level, x, y, z);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_FUEL, (Object)false);
        builder.define(PRIMARY_COLOR, (Object)this.getDefaultPrimaryColor().getId());
        builder.define(SECONDARY_COLOR, (Object)this.getDefaultSecondaryColor().getId());
        builder.define(MODE, (Object)Mode.SHUTDOWN);
        builder.define(SPEED, (Object)Speed.NORMAL);
        builder.define(LOCK, (Object)Lock.UNLOCKED);
        builder.define(REVERSE, (Object)false);
        builder.define(DESTINATION, (Object)"");
        builder.define(OWNER, Optional.empty());
    }

    protected DyeColor getDefaultPrimaryColor() {
        return DyeColor.PURPLE;
    }

    protected DyeColor getDefaultSecondaryColor() {
        return DyeColor.BLACK;
    }

    @Override
    protected void loadFromItemStack(ItemStack itemStack) {
        super.loadFromItemStack(itemStack);
        if (!(itemStack.getItem() instanceof LocomotiveItem)) {
            return;
        }
        LocomotiveColorComponent color = LocomotiveItem.getColor(itemStack);
        this.setPrimaryColor(color.primary());
        this.setSecondaryColor(color.secondary());
        this.whistlePitch = ((LocomotiveWhistlePitchComponent)itemStack.getOrDefault(RailcraftDataComponents.LOCOMOTIVE_WHISTLE_PITCH, (Object)new LocomotiveWhistlePitchComponent(this.getNewWhistlePitch()))).whistlePitch();
        if (itemStack.has(RailcraftDataComponents.LOCOMOTIVE_OWNER)) {
            NameAndId owner = ((LocomotiveOwnerComponent)itemStack.get(RailcraftDataComponents.LOCOMOTIVE_OWNER)).owner();
            this.setOwner(owner);
            this.setLock(Lock.LOCKED);
        }
        if (itemStack.has(RailcraftDataComponents.LOCOMOTIVE_LOCK)) {
            this.setLock(((LocomotiveLockComponent)itemStack.get(RailcraftDataComponents.LOCOMOTIVE_LOCK)).lock());
        }
    }

    @Override
    public Optional<NameAndId> getOwner() {
        return (Optional)this.entityData.get(OWNER);
    }

    @Override
    public void setOwner(@Nullable NameAndId owner) {
        this.entityData.set(OWNER, Optional.ofNullable(owner));
    }

    private float getNewWhistlePitch() {
        return 1.0f + (float)this.random.nextGaussian() * 0.2f;
    }

    @Override
    public ItemStack getPickResult() {
        ItemStack itemStack = this.getDropItem().getDefaultInstance();
        if (this.isLocked()) {
            LocomotiveItem.setOwnerData(itemStack, this.getOwnerOrThrow());
        }
        LocomotiveItem.setItemColorData(itemStack, this.getPrimaryDyeColor(), this.getSecondaryDyeColor());
        LocomotiveItem.setItemWhistleData(itemStack, this.whistlePitch);
        if (this.hasCustomName()) {
            itemStack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        return itemStack;
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.level().isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (!itemStack.isEmpty() && itemStack.is((Item)RailcraftItems.WHISTLE_TUNER.get())) {
            if (this.whistleDelay <= 0) {
                this.whistlePitch = this.getNewWhistlePitch();
                this.whistle();
                itemStack.hurtAndBreak(1, (ServerLevel)this.level(), (ServerPlayer)player, item -> player.onEquippedItemBroken(item, hand.asEquipmentSlot()));
            }
            return InteractionResult.SUCCESS;
        }
        if (this.canControl(player)) {
            return super.interact(player, hand);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean isLocked() {
        return this.getLock() == Lock.LOCKED || this.isPrivate();
    }

    public boolean isPrivate() {
        return this.getLock() == Lock.PRIVATE;
    }

    public boolean canControl(Player player) {
        return !this.isPrivate() || PlayerUtil.isOwnerOrOp(this.getOwner().orElseThrow(() -> new IllegalStateException("Locomotive is private but has no owner.")), player);
    }

    public Lock getLock() {
        return (Lock)this.entityData.get(LOCK);
    }

    public void setLock(Lock lock) {
        this.entityData.set(LOCK, (Object)lock);
    }

    @Override
    public String getDestination() {
        return (String)this.entityData.get(DESTINATION);
    }

    public void setDestination(String destination) {
        this.entityData.set(DESTINATION, (Object)destination);
    }

    @Override
    public boolean setDestination(ItemStack ticket) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (ticket.getItem() instanceof TicketItem) {
            String destination;
            if (this.isLocked()) {
                NameAndId ticketOwner = TicketItem.getOwner(ticket);
                if (ticketOwner == null) {
                    return false;
                }
                if (!this.getOwnerOrThrow().equals((Object)ticketOwner) && !serverLevel.getServer().getPlayerList().isOp(ticketOwner)) {
                    return false;
                }
            }
            if (!(destination = TicketItem.getDestination(ticket)).equals(this.getDestination())) {
                this.setDestination(destination);
                this.ticketContainer().setItem(1, TicketItem.copyTicket(ticket));
                return true;
            }
        }
        return false;
    }

    public Mode getMode() {
        return (Mode)((Object)this.entityData.get(MODE));
    }

    public void setMode(Mode mode) {
        if (!this.isAllowedMode(mode)) {
            return;
        }
        this.entityData.set(MODE, (Object)mode);
    }

    public Set<Mode> getSupportedModes() {
        return SUPPORTED_MODES;
    }

    public boolean isAllowedMode(Mode mode) {
        return this.getSupportedModes().contains((Object)mode);
    }

    public Speed getSpeed() {
        return (Speed)((Object)this.entityData.get(SPEED));
    }

    public void setSpeed(Speed speed) {
        if (this.isReverse() && speed.getLevel() > this.getMaxReverseSpeed().getLevel()) {
            return;
        }
        this.entityData.set(SPEED, (Object)speed);
    }

    public Speed getMaxReverseSpeed() {
        return Speed.NORMAL;
    }

    public void increaseSpeed() {
        this.setSpeed(this.getSpeed().shiftUp());
    }

    public void decreaseSpeed() {
        this.setSpeed(this.getSpeed().shiftDown());
    }

    public boolean hasFuel() {
        return (Boolean)this.entityData.get(HAS_FUEL);
    }

    public void setHasFuel(boolean hasFuel) {
        this.entityData.set(HAS_FUEL, (Object)hasFuel);
    }

    public boolean isReverse() {
        return (Boolean)this.entityData.get(REVERSE);
    }

    public void setReverse(boolean reverse) {
        this.entityData.set(REVERSE, (Object)reverse);
    }

    public boolean isRunning() {
        return this.hasFuel() && this.getMode() == Mode.RUNNING && !this.isIdle() && !this.isShutdown();
    }

    public boolean isIdle() {
        return !this.isShutdown() && (this.tempIdle > 0 || this.getMode() == Mode.IDLE || !this.level().isClientSide() && RollingStock.getOrThrow((AbstractMinecart)this).train().isIdle());
    }

    public boolean isShutdown() {
        return this.getMode() == Mode.SHUTDOWN || !this.level().isClientSide() && RollingStock.getOrThrow((AbstractMinecart)this).train().state().isStopped();
    }

    public void forceIdle(int ticks) {
        this.tempIdle = Math.max(this.tempIdle, ticks);
    }

    @Override
    public void reverse() {
        this.setYRot(this.getYRot() + 180.0f);
        this.setDeltaMovement(this.getDeltaMovement().multiply(-1.0, 1.0, -1.0));
    }

    @Override
    public void setRenderYaw(float yaw) {
        this.renderYaw = yaw;
    }

    public abstract SoundEvent getWhistleSound();

    public final void whistle() {
        if (this.whistleDelay <= 0) {
            this.level().playSound(null, (Entity)this, this.getWhistleSound(), this.getSoundSource(), 1.0f, this.whistlePitch);
            this.whistleDelay = 160;
        }
    }

    public final void tick() {
        super.tick();
        if (this.isRemoved()) {
            return;
        }
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            this.clientTick(this.level());
        } else {
            ServerLevel serverLevel = (ServerLevel)level;
            this.serverTick(serverLevel);
        }
    }

    protected void serverTick(ServerLevel level) {
        this.processTicket();
        this.updateFuel();
        if (this.whistleDelay > 0) {
            --this.whistleDelay;
        }
        if (this.tempIdle > 0) {
            --this.tempIdle;
        }
        if (this.tickCount % 256 == 0 && this.isRunning() && this.random.nextInt(4) == 0) {
            this.whistle();
        }
    }

    protected void clientTick(Level level) {
        if (!(!Seasons.isPolarExpress((AbstractMinecart)this) || MathUtil.nearZero(this.getDeltaMovement().x()) && MathUtil.nearZero(this.getDeltaMovement().z()))) {
            this.snowEffect(this.getX(), this.getBoundingBox().minY - this.getY(), this.getZ());
        }
    }

    private void snowEffect(double x, double y, double z) {
        double vx = this.random.nextGaussian() * 0.1;
        double vy = this.random.nextDouble() * 0.01;
        double vz = this.random.nextGaussian() * 0.1;
        this.level().addParticle((ParticleOptions)ParticleTypes.ITEM_SNOWBALL, x, y, z, vx, vy, vz);
    }

    protected abstract Container ticketContainer();

    private void processTicket() {
        Container ticketContainer = this.ticketContainer();
        ItemStack ticketStack = ticketContainer.getItem(0);
        if (ticketStack.getItem() instanceof TicketItem) {
            if (this.setDestination(ticketStack)) {
                ticketContainer.setItem(0, ContainerTools.depleteItem(ticketStack));
            }
            return;
        }
        ticketContainer.setItem(0, ItemStack.EMPTY);
    }

    public Vec3 applyNaturalSlowdown(Vec3 entitySpeed) {
        if (this.isRemoved()) {
            return Vec3.ZERO;
        }
        Vec3 result = this.getDeltaMovement().multiply(this.getDrag(), 0.0, this.getDrag());
        if (this.isReverse() && this.getSpeed().getLevel() > this.getMaxReverseSpeed().getLevel()) {
            this.setSpeed(this.getMaxReverseSpeed());
        }
        Speed speed = this.getSpeed();
        if (this.isRunning()) {
            double force = (Double)RailcraftConfig.SERVER.locomotiveHorsepower.get() * (double)0.01f;
            if (this.isReverse()) {
                force = -force;
            }
            if (speed.equals((Object)Speed.MAX) && RollingStock.getOrThrow((AbstractMinecart)this).isHighSpeed()) {
                force *= 3.5;
            }
            double yaw = this.getYRot() * ((float)Math.PI / 180);
            result = result.add(Math.cos(yaw) * force, 0.0, Math.sin(yaw) * force);
        }
        if (speed != Speed.MAX) {
            float limit = switch (speed.ordinal()) {
                case 0 -> 0.1f;
                case 1 -> 0.2f;
                case 2 -> 0.3f;
                default -> 0.4f;
            };
            return new Vec3(Math.copySign(Math.min(Math.abs(result.x()), (double)limit), result.x()), result.y(), Math.copySign(Math.min(Math.abs(result.z()), (double)limit), result.z()));
        }
        return result;
    }

    private int getFuelUse() {
        if (this.isRunning()) {
            return switch (this.getSpeed().ordinal()) {
                case 0 -> 2;
                case 1 -> 4;
                case 2 -> 6;
                default -> 8;
            };
        }
        if (this.isIdle()) {
            return this.getIdleFuelUse();
        }
        return 0;
    }

    protected int getIdleFuelUse() {
        return 1;
    }

    protected void updateFuel() {
        int newFuel;
        if (this.tickCount % 8 == 0 && this.fuel > 0) {
            this.fuel -= this.getFuelUse();
            if (this.fuel < 0) {
                this.fuel = 0;
            }
        }
        while (this.fuel <= 8 && !this.isShutdown() && (newFuel = this.retrieveFuel()) > 0) {
            this.fuel += newFuel;
        }
        this.setHasFuel(this.fuel > 0);
    }

    protected abstract int retrieveFuel();

    private int getDamageToRoadKill(LivingEntity entity) {
        ServerPlayer player;
        ItemStack pants;
        if (entity instanceof ServerPlayer && (pants = (player = (ServerPlayer)entity).getItemBySlot(EquipmentSlot.LEGS)).is((Item)RailcraftItems.OVERALLS.get())) {
            pants.hurtAndBreak(5, player.level(), player, item -> player.onEquippedItemBroken(item, EquipmentSlot.LEGS));
            return 4;
        }
        return 25;
    }

    public void push(Entity entity) {
        if (!this.level().isClientSide()) {
            if (!entity.isAlive()) {
                return;
            }
            RollingStock extension = RollingStock.getOrThrow((AbstractMinecart)this);
            if (extension.train().entities().noneMatch(t -> t.hasPassenger(entity)) && (this.isVelocityHigherThan(0.2f) || extension.isHighSpeed()) && ModEntitySelector.KILLABLE.test(entity)) {
                LivingEntity living = (LivingEntity)entity;
                if (((Boolean)RailcraftConfig.SERVER.locomotiveDamageMobs.get()).booleanValue()) {
                    living.hurt((DamageSource)RailcraftDamageSources.train(this.level().registryAccess()), (float)this.getDamageToRoadKill(living));
                }
                if (living.getHealth() > 0.0f) {
                    float yaw = (this.getYRot() - 90.0f) * ((float)Math.PI / 180);
                    this.setDeltaMovement(this.getDeltaMovement().add((double)(-Mth.sin((float)yaw) * 1.0f * 0.5f), 0.2, (double)(Mth.cos((float)yaw) * 1.0f * 0.5f)));
                } else if (living instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)living;
                    ((KilledByLocomotiveTrigger)((Object)RailcraftCriteriaTriggers.KILLED_BY_LOCOMOTIVE.value())).trigger(serverPlayer, (AbstractMinecart)this);
                }
                return;
            }
            if (this.collidedWithOtherLocomotive(entity)) {
                Locomotive otherLoco = (Locomotive)entity;
                this.explode();
                if (otherLoco.isAlive()) {
                    otherLoco.explode();
                }
                return;
            }
        }
        super.push(entity);
    }

    private boolean collidedWithOtherLocomotive(Entity entity) {
        if (!(entity instanceof Locomotive)) {
            return false;
        }
        Locomotive otherLoco = (Locomotive)entity;
        if (this.getUUID().equals(entity.getUUID())) {
            return false;
        }
        if (RollingStock.getOrThrow((AbstractMinecart)this).isSameTrainAs(RollingStock.getOrThrow((AbstractMinecart)otherLoco))) {
            return false;
        }
        Vec3 motion = this.getDeltaMovement();
        Vec3 otherMotion = entity.getDeltaMovement();
        return this.isVelocityHigherThan(0.2f) && otherLoco.isVelocityHigherThan(0.2f) && (Math.abs(motion.x() - otherMotion.x()) > (double)0.3f || Math.abs(motion.z() - otherMotion.z()) > (double)0.3f);
    }

    private boolean isVelocityHigherThan(float velocity) {
        return Math.abs(this.getDeltaMovement().x()) > (double)velocity || Math.abs(this.getDeltaMovement().z()) > (double)velocity;
    }

    @Override
    public void remove(Entity.RemovalReason reason) {
        this.ticketContainer().setItem(1, ItemStack.EMPTY);
        super.remove(reason);
    }

    public void explode() {
        MinecartUtil.explodeCart((AbstractMinecart)this);
        this.remove(Entity.RemovalReason.KILLED);
    }

    public double getDrag() {
        return 0.9;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putBoolean("flipped", this.flipped);
        valueOutput.putString("dest", (String)StringUtils.defaultIfBlank((CharSequence)this.getDestination(), (CharSequence)""));
        valueOutput.store("mode", Mode.CODEC, (Object)this.getMode());
        valueOutput.store("speed", Speed.CODEC, (Object)this.getSpeed());
        valueOutput.store("lock", Lock.CODEC, (Object)this.getLock());
        valueOutput.store("primaryColor", (Codec)DyeColor.CODEC, (Object)DyeColor.byId((int)((Integer)this.entityData.get(PRIMARY_COLOR))));
        valueOutput.store("secondaryColor", (Codec)DyeColor.CODEC, (Object)DyeColor.byId((int)((Integer)this.entityData.get(SECONDARY_COLOR))));
        valueOutput.putFloat("whistlePitch", this.whistlePitch);
        valueOutput.putInt("fuel", this.fuel);
        valueOutput.putBoolean("reverse", this.isReverse());
        this.getOwner().ifPresent(owner -> valueOutput.store("owner", NameAndId.CODEC, owner));
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.flipped = valueInput.getBooleanOr("flipped", false);
        this.setDestination(valueInput.getStringOr("dest", ""));
        this.setMode(valueInput.read("mode", Mode.CODEC).orElse(Mode.IDLE));
        this.setSpeed(valueInput.read("speed", Speed.CODEC).orElse(Speed.NORMAL));
        this.setLock(valueInput.read("lock", Lock.CODEC).orElse(Lock.UNLOCKED));
        this.setPrimaryColor(valueInput.read("primaryColor", (Codec)DyeColor.CODEC).orElse(this.getDefaultPrimaryColor()));
        this.setSecondaryColor(valueInput.read("secondaryColor", (Codec)DyeColor.CODEC).orElse(this.getDefaultSecondaryColor()));
        this.whistlePitch = valueInput.getFloatOr("whistlePitch", this.getNewWhistlePitch());
        this.fuel = valueInput.getIntOr("fuel", 0);
        this.entityData.set(REVERSE, (Object)valueInput.getBooleanOr("reverse", false));
        this.setOwner(valueInput.read("owner", NameAndId.CODEC).orElse(null));
    }

    public static void applyAction(Player player, AbstractMinecart minecart, boolean single, Consumer<Locomotive> action) {
        Stream<Locomotive> locos = RollingStock.getOrThrow(minecart).train().entities().flatMap(FunctionalUtil.ofType(Locomotive.class)).filter(loco -> loco.canControl(player));
        if (single) {
            locos.findAny().ifPresent(action);
        } else {
            locos.forEach(action);
        }
    }

    public int getContainerSize() {
        return 0;
    }

    @Override
    public boolean isPoweredCart() {
        return true;
    }

    @Override
    public float getOptimalDistance(RollingStock cart) {
        return 0.9f;
    }

    @Override
    public void linked(RollingStock cart) {
        if (this.getSpeed().compareTo(Speed.SLOWEST) > 0) {
            this.setSpeed(Speed.SLOWEST);
        }
    }

    @Override
    public boolean canPassItemRequests(ItemStack stack) {
        return true;
    }

    @Override
    public final DyeColor getPrimaryDyeColor() {
        return DyeColor.byId((int)((Integer)this.entityData.get(PRIMARY_COLOR)));
    }

    public final void setPrimaryColor(DyeColor color) {
        this.entityData.set(PRIMARY_COLOR, (Object)color.getId());
    }

    @Override
    public final DyeColor getSecondaryDyeColor() {
        return DyeColor.byId((int)((Integer)this.entityData.get(SECONDARY_COLOR)));
    }

    public final void setSecondaryColor(DyeColor color) {
        this.entityData.set(SECONDARY_COLOR, (Object)color.getId());
    }

    public static enum Mode implements StringRepresentable
    {
        SHUTDOWN(Translations.Screen.LOCOMOTIVE_MODE_SHUTDOWN),
        IDLE(Translations.Screen.LOCOMOTIVE_MODE_IDLE),
        RUNNING(Translations.Screen.LOCOMOTIVE_MODE_RUNNING);

        private static final StringRepresentable.EnumCodec<Mode> CODEC;
        private final String name;
        private final String translationKey;

        private Mode(String translationKey) {
            this.translationKey = translationKey;
            this.name = translationKey.substring(translationKey.lastIndexOf(46) + 1);
        }

        public Mode next() {
            return (Mode)EnumUtil.next((Enum)this, (Enum[])Mode.values());
        }

        public Mode previous() {
            return (Mode)EnumUtil.previous((Enum)this, (Enum[])Mode.values());
        }

        public String getSerializedName() {
            return this.name;
        }

        public Component getDisplayName() {
            return Component.translatable((String)this.translationKey);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Mode::values);
        }
    }

    public static enum Speed implements StringRepresentable
    {
        SLOWEST("slowest", 1, 1, 0),
        SLOWER("slower", 2, 1, -1),
        NORMAL("normal", 3, 1, -1),
        MAX("max", 4, 0, -1);

        private static final StringRepresentable.EnumCodec<Speed> CODEC;
        private final String name;
        private final int shiftUp;
        private final int shiftDown;
        private final int level;

        private Speed(String name, int level, int shiftUp, int shiftDown) {
            this.name = name;
            this.level = level;
            this.shiftUp = shiftUp;
            this.shiftDown = shiftDown;
        }

        public int getLevel() {
            return this.level;
        }

        public String getSerializedName() {
            return this.name;
        }

        public Speed shiftUp() {
            return Speed.values()[this.ordinal() + this.shiftUp];
        }

        public Speed shiftDown() {
            return Speed.values()[this.ordinal() + this.shiftDown];
        }

        static {
            CODEC = StringRepresentable.fromEnum(Speed::values);
        }
    }

    public static enum Lock implements ButtonState<Lock>,
    StringRepresentable
    {
        UNLOCKED("unlocked", ButtonTexture.UNLOCKED_BUTTON),
        LOCKED("locked", ButtonTexture.LOCKED_BUTTON),
        PRIVATE("private", new SimpleTexturePosition(240, 48, 16, 16));

        public static final StringRepresentable.EnumCodec<Lock> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Lock> STREAM_CODEC;
        private final String name;
        private final TexturePosition texture;

        private Lock(String name, TexturePosition texture) {
            this.name = name;
            this.texture = texture;
        }

        @Override
        public Component label() {
            return Component.empty();
        }

        @Override
        public TexturePosition texturePosition() {
            return this.texture;
        }

        @Override
        public Lock next() {
            return (Lock)EnumUtil.next((Enum)this, (Enum[])Lock.values());
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Lock::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Lock.class);
        }
    }
}

