/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.inventory;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import mods.railcraft.gui.widget.Widget;
import mods.railcraft.network.to_client.SyncWidgetMessage;
import mods.railcraft.world.inventory.slot.RailcraftSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.connection.ConnectionType;
import org.jetbrains.annotations.Nullable;

public abstract class RailcraftMenu
extends AbstractContainerMenu {
    private final Player player;
    private final Predicate<Player> validator;
    private final List<Widget> widgets = new ArrayList<Widget>();

    protected RailcraftMenu(@Nullable MenuType<?> type, int id, Player player, Predicate<Player> validator) {
        super(type, id);
        this.player = player;
        this.validator = validator;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean stillValid(Player player) {
        return this.validator.test(player);
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    protected final void addInventorySlots(Inventory inventory) {
        this.addInventorySlots(inventory, 166);
    }

    protected final void addInventorySlots(Inventory inventory, int guiHeight) {
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)inventory, k + i * 9 + 9, 8 + k * 18, guiHeight - 82 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)inventory, j, 8 + j * 18, guiHeight - 24));
        }
    }

    public void addWidget(Widget widget) {
        this.widgets.add(widget);
        widget.added(this);
    }

    public final void broadcastChanges() {
        super.broadcastChanges();
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.widgets.forEach(widget -> this.sendWidgetPacket(serverPlayer, (Widget)widget));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendWidgetPacket(ServerPlayer player, Widget widget) {
        if (widget.requiresSync(player)) {
            RegistryFriendlyByteBuf byteBuf = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.buffer()), player.registryAccess(), ConnectionType.OTHER);
            try {
                widget.writeToBuf(player, byteBuf);
                SyncWidgetMessage message = new SyncWidgetMessage(this.containerId, widget.getId(), byteBuf.array());
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public void clicked(int slotId, int mouseButton, ClickType clickType, Player player) {
        RailcraftSlot railcraftSlot;
        Slot slot;
        if (slotId >= 0 && (slot = (Slot)this.slots.get(slotId)) instanceof RailcraftSlot && (railcraftSlot = (RailcraftSlot)slot).isPhantom()) {
            this.slotClickPhantom(railcraftSlot, mouseButton, clickType, player);
        }
        super.clicked(slotId, mouseButton, clickType, player);
    }

    private void slotClickPhantom(RailcraftSlot slot, int mouseButton, ClickType clickType, Player player) {
        if (mouseButton == 2) {
            if (slot.canAdjustPhantom()) {
                slot.set(ItemStack.EMPTY);
            }
        } else if (mouseButton == 0 || mouseButton == 1) {
            AbstractContainerMenu containerMenu = player.containerMenu;
            slot.setChanged();
            ItemStack stackSlot = slot.getItem();
            ItemStack stackHeld = containerMenu.getCarried();
            if (stackSlot.isEmpty() && !stackHeld.isEmpty() && slot.mayPlace(stackHeld)) {
                this.fillPhantomSlot(slot, stackHeld, mouseButton);
            } else if (stackHeld.isEmpty()) {
                this.adjustPhantomSlot(slot, mouseButton, clickType);
                slot.onTake(player, containerMenu.getCarried());
            }
        }
    }

    private void adjustPhantomSlot(RailcraftSlot slot, int mouseButton, ClickType clickType) {
        int stackSize;
        if (!slot.canAdjustPhantom()) {
            return;
        }
        ItemStack stackSlot = slot.getItem();
        if (stackSlot.isEmpty()) {
            return;
        }
        if (clickType == ClickType.QUICK_MOVE) {
            stackSize = mouseButton == 0 ? (stackSlot.getCount() + 1) / 2 : stackSlot.getCount() * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.getCount() - 1 : stackSlot.getCount() + 1;
        }
        if (stackSize > slot.getMaxStackSize()) {
            stackSize = slot.getMaxStackSize();
        }
        stackSlot.setCount(stackSize);
        if (stackSlot.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        }
    }

    private void fillPhantomSlot(RailcraftSlot slot, ItemStack stackHeld, int mouseButton) {
        int stackSize;
        if (!slot.canAdjustPhantom()) {
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.getCount() : 1;
        if (stackSize > slot.getMaxStackSize()) {
            stackSize = slot.getMaxStackSize();
        }
        ItemStack phantomStack = stackHeld.copy();
        phantomStack.setCount(stackSize);
        slot.set(phantomStack);
    }

    private boolean tryMoveItemStackTo(ItemStack itemStack, int endIndex) {
        Slot slot;
        int i;
        boolean changed = false;
        if (itemStack.isStackable()) {
            for (i = 0; !itemStack.isEmpty() && i < endIndex; ++i) {
                int maxSize;
                slot = (Slot)this.slots.get(i);
                ItemStack stackInSlot = slot.getItem();
                if (stackInSlot.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)stackInSlot)) continue;
                int j = stackInSlot.getCount() + itemStack.getCount();
                if (j <= (maxSize = Math.min(slot.getMaxStackSize(), itemStack.getMaxStackSize()))) {
                    itemStack.setCount(0);
                    stackInSlot.setCount(j);
                    slot.setChanged();
                    changed = true;
                    continue;
                }
                if (stackInSlot.getCount() >= maxSize) continue;
                itemStack.shrink(maxSize - stackInSlot.getCount());
                stackInSlot.setCount(maxSize);
                slot.setChanged();
                changed = true;
            }
        }
        if (!itemStack.isEmpty()) {
            for (i = 0; i < endIndex; ++i) {
                slot = (Slot)this.slots.get(i);
                ItemStack itemstack = slot.getItem();
                if (!itemstack.isEmpty() || !RailcraftMenu.mayPlace(slot, itemStack)) continue;
                if (itemStack.getCount() > slot.getMaxStackSize()) {
                    slot.setByPlayer(itemStack.split(slot.getMaxStackSize()));
                } else {
                    slot.setByPlayer(itemStack.split(itemStack.getCount()));
                }
                slot.setChanged();
                changed = true;
                break;
            }
        }
        return changed;
    }

    private static boolean mayPlace(Slot slot, ItemStack itemStack) {
        if (slot instanceof RailcraftSlot) {
            RailcraftSlot railcraftSlot = (RailcraftSlot)slot;
            if (railcraftSlot.isPhantom()) {
                return false;
            }
            if (!railcraftSlot.canShift()) {
                return false;
            }
        }
        return slot.mayPlace(itemStack);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack originalStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        int numSlots = this.slots.size();
        int slotsAdded = numSlots - 36;
        if (slot.hasItem() && slotsAdded > 0) {
            ItemStack stackInSlot = slot.getItem();
            originalStack = stackInSlot.copy();
            if (slotIndex < slotsAdded ? !this.moveItemStackTo(stackInSlot, slotsAdded, numSlots, false) : !this.tryMoveItemStackTo(stackInSlot, slotsAdded)) {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return originalStack;
    }
}

