/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.function.Consumer;
import mods.railcraft.Translations;
import mods.railcraft.api.util.EnumUtil;
import mods.railcraft.network.to_server.UpdateAuraByKeyMessage;
import mods.railcraft.world.item.component.AuraComponent;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class GogglesItem
extends Item {
    public GogglesItem(Item.Properties properties) {
        super(properties);
    }

    public static Aura getAura(ItemStack itemStack) {
        if (itemStack.has(RailcraftDataComponents.AURA)) {
            return ((AuraComponent)itemStack.get(RailcraftDataComponents.AURA)).aura();
        }
        return Aura.NONE;
    }

    public static Aura incrementAura(ItemStack itemStack) {
        Aura aura = GogglesItem.getAura(itemStack).getNext();
        if (aura == Aura.TRACKING) {
            aura.getNext();
        }
        itemStack.set(RailcraftDataComponents.AURA, (Object)new AuraComponent(aura));
        return aura;
    }

    public static void changeAuraByKey(LocalPlayer player) {
        ItemStack itemStack = player.getItemBySlot(EquipmentSlot.HEAD);
        if (itemStack.isEmpty()) {
            return;
        }
        Aura aura = GogglesItem.incrementAura(itemStack);
        player.displayClientMessage(GogglesItem.getDescriptionText(aura.getDisplayName(), false), true);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new UpdateAuraByKeyMessage(aura), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static boolean isGoggleAuraActive(Aura aura) {
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack itemStack = player.getItemBySlot(EquipmentSlot.HEAD);
        return itemStack.getItem() instanceof GogglesItem && GogglesItem.getAura(itemStack) == aura;
    }

    private static Component getDescriptionText(MutableComponent value, boolean tooltip) {
        MutableComponent title = Component.translatable((String)Translations.Tips.GOGGLES_AURA);
        if (tooltip) {
            title.withStyle(ChatFormatting.GRAY);
        }
        return title.append(CommonComponents.SPACE).append((Component)value.withStyle(ChatFormatting.DARK_PURPLE));
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            Aura aura = GogglesItem.incrementAura(itemStack);
            player.displayClientMessage(GogglesItem.getDescriptionText(aura.getDisplayName(), false), true);
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        tooltipAdder.accept(GogglesItem.getDescriptionText(GogglesItem.getAura(stack).getDisplayName(), true));
        tooltipAdder.accept((Component)Component.translatable((String)Translations.Tips.GOGGLES_DESC).withStyle(ChatFormatting.GRAY));
    }

    public static enum Aura implements StringRepresentable
    {
        NONE(Translations.Tips.GOGGLES_AURA_NONE),
        TRACKING(Translations.Tips.GOGGLES_AURA_TRACKING),
        TUNING(Translations.Tips.GOGGLES_AURA_TUNING),
        SHUNTING(Translations.Tips.GOGGLES_AURA_SHUNTING),
        SIGNALLING(Translations.Tips.GOGGLES_AURA_SIGNALLING),
        SURVEYING(Translations.Tips.GOGGLES_AURA_SURVEYING),
        WORLDSPIKE(Translations.Tips.GOGGLES_AURA_WORLDSPIKE);

        public static final StringRepresentable.EnumCodec<Aura> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Aura> STREAM_CODEC;
        private final String name;
        private final String translationKey;

        private Aura(String translationKey) {
            this.translationKey = translationKey;
            this.name = translationKey.substring(translationKey.lastIndexOf(46) + 1);
        }

        public MutableComponent getDisplayName() {
            return Component.translatable((String)this.translationKey);
        }

        public String getSerializedName() {
            return this.name;
        }

        public Aura getNext() {
            return (Aura)EnumUtil.next((Enum)this, (Enum[])Aura.values());
        }

        static {
            CODEC = StringRepresentable.fromEnum(Aura::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Aura.class);
        }
    }
}

