/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mods.railcraft.client.ScreenFactories;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import mods.railcraft.world.item.component.RoutingTableBookContent;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;

public class RoutingTableBookItem
extends Item {
    public static final Predicate<ItemStack> FILTER = stack -> stack != null && stack.getItem() instanceof RoutingTableBookItem;

    public RoutingTableBookItem(Item.Properties properties) {
        super(properties);
    }

    public Component getName(ItemStack stack) {
        Optional<String> title;
        Component name = super.getName(stack);
        RoutingTableBookContent content = (RoutingTableBookContent)stack.get(RailcraftDataComponents.ROUTING_TABLE_BOOK);
        if (content != null && (title = content.title()).isPresent() && !title.get().isEmpty()) {
            name = name.copy().append(" - " + title.get());
        }
        return name;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        RoutingTableBookContent content = (RoutingTableBookContent)stack.get(RailcraftDataComponents.ROUTING_TABLE_BOOK);
        if (content != null) {
            content.addToTooltip(context, tooltipAdder, flag, (DataComponentGetter)this.components());
        }
    }

    public InteractionResult use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (level.isClientSide()) {
            ScreenFactories.openRoutingTableBookScreen(player, itemStack, usedHand);
        }
        return InteractionResult.SUCCESS;
    }
}

