/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.function.Consumer;
import mods.railcraft.Translations;
import mods.railcraft.season.Season;
import mods.railcraft.world.item.CrowbarItem;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import mods.railcraft.world.item.component.SeasonComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;

public class SeasonsCrowbarItem
extends CrowbarItem {
    public SeasonsCrowbarItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            SeasonsCrowbarItem.incrementSeason(itemStack);
            Season season = SeasonsCrowbarItem.getSeason(itemStack);
            player.displayClientMessage(SeasonsCrowbarItem.getDescriptionText(season, false), true);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        Season season = SeasonsCrowbarItem.getSeason(stack);
        tooltipAdder.accept(SeasonsCrowbarItem.getDescriptionText(season, true));
    }

    public static Season getSeason(ItemStack itemStack) {
        if (itemStack.has(RailcraftDataComponents.SEASON)) {
            return ((SeasonComponent)itemStack.get(RailcraftDataComponents.SEASON)).season();
        }
        return Season.DEFAULT;
    }

    private static void incrementSeason(ItemStack itemStack) {
        Season season = SeasonsCrowbarItem.getSeason(itemStack).getNext();
        itemStack.set(RailcraftDataComponents.SEASON, (Object)new SeasonComponent(season));
    }

    private static Component getDescriptionText(Season value, boolean tooltip) {
        MutableComponent title = Component.translatable((String)Translations.Tips.CROWBAR_SEASON_DESC);
        if (tooltip) {
            title.withStyle(ChatFormatting.GRAY);
        }
        return title.append(CommonComponents.SPACE).append((Component)value.getDisplayName().copy().withStyle(ChatFormatting.DARK_PURPLE));
    }
}

