/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.function.Consumer;
import mods.railcraft.Translations;
import mods.railcraft.api.signal.TrackLocator;
import mods.railcraft.api.signal.entity.MonitoringSignalEntity;
import mods.railcraft.world.item.PairingToolItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import org.jetbrains.annotations.Nullable;

public class SignalBlockSurveyorItem
extends PairingToolItem<MonitoringSignalEntity, MonitoringSignalEntity> {
    public SignalBlockSurveyorItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        tooltipAdder.accept((Component)Component.translatable((String)Translations.Tips.SIGNAL_BLOCK_SURVEYOR).withStyle(ChatFormatting.GRAY));
    }

    @Override
    protected Class<MonitoringSignalEntity> targetType() {
        return MonitoringSignalEntity.class;
    }

    @Override
    protected Class<MonitoringSignalEntity> peerType() {
        return MonitoringSignalEntity.class;
    }

    @Override
    protected Component getMessageForState(PairingToolItem.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case PairingToolItem.State.ABANDONED -> Component.translatable((String)Translations.Signal.SIGNAL_SURVEYOR_ABANDONED).withStyle(ChatFormatting.LIGHT_PURPLE);
            case PairingToolItem.State.LOST_TARGET -> Component.translatable((String)Translations.Signal.SIGNAL_SURVEYOR_LOST).withStyle(ChatFormatting.RED);
            case PairingToolItem.State.INVALID_TARGET, PairingToolItem.State.INVALID_PEER -> Component.translatable((String)Translations.Signal.SIGNAL_SURVEYOR_INVALID_BLOCK).withStyle(ChatFormatting.RED);
        };
    }

    @Override
    protected void abandon(@Nullable MonitoringSignalEntity target) {
        if (target != null) {
            target.signalNetwork().stopLinking();
        }
    }

    @Override
    protected PairingToolItem.Result begin(MonitoringSignalEntity target) {
        TrackLocator.Status trackStatus = target.trackLocator().trackStatus();
        if (trackStatus.invalid()) {
            return PairingToolItem.Result.failure((Component)Component.translatable((String)Translations.Signal.SIGNAL_SURVEYOR_INVALID_TRACK).withStyle(ChatFormatting.RED));
        }
        target.signalNetwork().startLinking();
        return PairingToolItem.Result.success((Component)Component.translatable((String)Translations.Signal.SIGNAL_SURVEYOR_BEGIN).withStyle(ChatFormatting.LIGHT_PURPLE));
    }

    @Override
    protected PairingToolItem.Result complete(MonitoringSignalEntity target, MonitoringSignalEntity peer) {
        if (!SignalBlockSurveyorItem.tryLinking(target, peer)) {
            return PairingToolItem.Result.failure((Component)Component.translatable((String)Translations.Signal.SIGNAL_SURVEYOR_INVALID_PAIR).withStyle(ChatFormatting.RED));
        }
        target.signalNetwork().stopLinking();
        peer.signalNetwork().stopLinking();
        return PairingToolItem.Result.success((Component)Component.translatable((String)Translations.Signal.SIGNAL_SURVEYOR_SUCCESS, (Object[])new Object[]{peer.getDisplayName(), target.getDisplayName()}).withStyle(ChatFormatting.GREEN));
    }

    public static <T, T2> boolean tryLinking(MonitoringSignalEntity<T> signal1, MonitoringSignalEntity<T2> signal2) {
        return signal1.type().isInstance(signal2) && signal2.type().isInstance(signal1) && signal1.signalNetwork().addPeer(signal1.type().cast(signal2)) && signal2.signalNetwork().addPeer(signal2.type().cast(signal1));
    }
}

