/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.function.Consumer;
import mods.railcraft.Translations;
import mods.railcraft.api.signal.entity.SignalEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SignalLabelItem
extends Item {
    public SignalLabelItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        BlockEntity blockEntity;
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player.isShiftKeyDown() && itemStack.has(DataComponents.CUSTOM_NAME) && (blockEntity = level.getBlockEntity(context.getClickedPos())) instanceof SignalEntity) {
            SignalEntity signal = (SignalEntity)blockEntity;
            if (!level.isClientSide()) {
                signal.setCustomName(itemStack.getHoverName());
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        tooltipAdder.accept((Component)Component.translatable((String)Translations.Tips.SIGNAL_LABEL_DESC1).withStyle(ChatFormatting.BLUE));
        tooltipAdder.accept((Component)Component.translatable((String)Translations.Tips.SIGNAL_LABEL_DESC2).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }
}

