/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.advancements.RailcraftCriteriaTriggers;
import mods.railcraft.advancements.UseTrackKitTrigger;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.world.level.block.track.TrackBlock;
import mods.railcraft.world.level.block.track.TrackTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.neoforged.neoforge.registries.DeferredHolder;

public class TrackKitItem
extends Item {
    private final Map<ResourceLocation, Supplier<? extends BaseRailBlock>> outfittedBlocks;
    private final boolean allowedOnSlopes;

    public TrackKitItem(Properties properties) {
        super((Item.Properties)properties);
        this.outfittedBlocks = properties.outfittedBlocks.build();
        this.allowedOnSlopes = properties.allowedOnSlopes;
    }

    public InteractionResult useOn(UseOnContext context) {
        TrackType trackType;
        Player player = context.getPlayer();
        Level level = context.getLevel();
        InteractionHand hand = context.getHand();
        ItemStack itemStack = player.getItemInHand(hand);
        BlockPos blockPos = context.getClickedPos();
        BlockState oldState = level.getBlockState(blockPos);
        if (!BaseRailBlock.isRail((BlockState)oldState)) {
            return InteractionResult.PASS;
        }
        Block block = oldState.getBlock();
        if (block instanceof TrackBlock) {
            TrackBlock trackBlock = (TrackBlock)block;
            trackType = trackBlock.getTrackType();
        } else if (oldState.is(Blocks.RAIL)) {
            trackType = (TrackType)TrackTypes.IRON.get();
        } else {
            return InteractionResult.PASS;
        }
        RailShape shape = TrackUtil.getRailShapeRaw((BlockGetter)level, blockPos);
        if (RailShapeUtil.isTurn(shape)) {
            player.displayClientMessage((Component)Component.translatable((String)Translations.Tips.TRACK_KIT_CORNERS_UNSUPPORTED).withStyle(ChatFormatting.RED), true);
            return InteractionResult.PASS;
        }
        if (shape.isSlope() && !this.allowedOnSlopes) {
            player.displayClientMessage((Component)Component.translatable((String)Translations.Tips.TRACK_KIT_SLOPES_UNSUPPORTED).withStyle(ChatFormatting.RED), true);
            return InteractionResult.PASS;
        }
        BaseRailBlock outfittedBlock = this.outfittedBlocks.getOrDefault(TrackTypes.REGISTRY.getKey((Object)trackType), () -> null).get();
        if (outfittedBlock == null) {
            player.displayClientMessage((Component)Component.translatable((String)Translations.Tips.TRACK_KIT_INVALID_TRACK_TYPE).withStyle(ChatFormatting.RED), true);
            return InteractionResult.PASS;
        }
        BlockState outfittedBlockState = outfittedBlock.getStateForPlacement(new BlockPlaceContext(context));
        if (level.setBlockAndUpdate(blockPos, outfittedBlockState)) {
            SoundType soundType = outfittedBlock.getSoundType(outfittedBlockState, (LevelReader)level, blockPos, (Entity)player);
            level.playSound((Entity)player, blockPos, soundType.getPlaceSound(), SoundSource.BLOCKS, soundType.getVolume(), soundType.getPitch());
            if (!level.isClientSide()) {
                ((UseTrackKitTrigger)((Object)RailcraftCriteriaTriggers.TRACK_KIT_USE.value())).trigger((ServerPlayer)player, (ServerLevel)level, blockPos, itemStack);
            }
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static class Properties
    extends Item.Properties {
        private final ImmutableMap.Builder<ResourceLocation, Supplier<? extends BaseRailBlock>> outfittedBlocks = ImmutableMap.builder();
        private boolean allowedOnSlopes;

        public Properties addOutfittedBlock(DeferredHolder<TrackType, ? extends TrackType> trackType, Supplier<? extends BaseRailBlock> block) {
            return this.addOutfittedBlock(trackType.getId(), block);
        }

        public Properties addOutfittedBlock(ResourceLocation trackTypeId, Supplier<? extends BaseRailBlock> block) {
            this.outfittedBlocks.put((Object)trackTypeId, block);
            return this;
        }

        public Properties setAllowedOnSlopes(boolean allowedOnSlopes) {
            this.allowedOnSlopes = allowedOnSlopes;
            return this;
        }
    }
}

