/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import mods.railcraft.Translations;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record RoutingTableBookContent(List<String> pages, String author, Optional<String> title) implements TooltipProvider
{
    public static final RoutingTableBookContent EMPTY = new RoutingTableBookContent(List.of(), "", Optional.empty());
    private static final int PAGE_EDIT_LENGTH = 1024;
    private static final int MAX_PAGES = 50;
    private static final Codec<String> PAGE_CODEC = Codec.string((int)0, (int)1024);
    private static final Codec<List<String>> PAGES_CODEC = PAGE_CODEC.sizeLimitedListOf(50);
    public static final Codec<RoutingTableBookContent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PAGES_CODEC.fieldOf("pages").forGetter(RoutingTableBookContent::pages), (App)Codec.STRING.fieldOf("author").forGetter(RoutingTableBookContent::author), (App)Codec.STRING.optionalFieldOf("title").forGetter(RoutingTableBookContent::title)).apply((Applicative)instance, RoutingTableBookContent::new));
    public static final StreamCodec<ByteBuf, RoutingTableBookContent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.stringUtf8((int)1024).apply(ByteBufCodecs.list((int)50)), RoutingTableBookContent::pages, (StreamCodec)ByteBufCodecs.STRING_UTF8, RoutingTableBookContent::author, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), RoutingTableBookContent::title, RoutingTableBookContent::new);

    public RoutingTableBookContent {
        if (pages.size() > 50) {
            throw new IllegalArgumentException("Got " + pages.size() + " pages, but maximum is 50");
        }
    }

    public void addToTooltip(Item.TooltipContext tooltipContext, Consumer<Component> consumer, TooltipFlag tooltipFlag, DataComponentGetter dataComponentGetter) {
        if (!this.author.isEmpty()) {
            consumer.accept((Component)Component.translatable((String)Translations.Tips.ROUTING_TABLE_BOOK_LAST_EDIT, (Object[])new Object[]{this.author}).withStyle(ChatFormatting.GRAY));
        }
    }
}

