/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.BlastFurnaceBricksBlock;
import mods.railcraft.world.level.block.RailcraftBlocks;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleItemRecipe;

public class BlastFurnaceRecipe
extends AbstractCookingRecipe {
    private final int slagOutput;

    public BlastFurnaceRecipe(Ingredient input, ItemStack result, float experience, int cookingTime, int slagOutput) {
        super("", CookingBookCategory.MISC, input, result, experience, cookingTime);
        this.slagOutput = slagOutput;
    }

    public int getSlagOutput() {
        return this.slagOutput;
    }

    public RecipeSerializer<BlastFurnaceRecipe> getSerializer() {
        return (RecipeSerializer)RailcraftRecipeSerializers.BLASTING.get();
    }

    public RecipeType<BlastFurnaceRecipe> getType() {
        return (RecipeType)RailcraftRecipeTypes.BLASTING.get();
    }

    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.CRAFTING_MISC;
    }

    public boolean isSpecial() {
        return true;
    }

    protected Item furnaceIcon() {
        return ((BlastFurnaceBricksBlock)((Object)RailcraftBlocks.BLAST_FURNACE_BRICKS.get())).asItem();
    }

    public static class Serializer
    implements RecipeSerializer<BlastFurnaceRecipe> {
        private static final MapCodec<BlastFurnaceRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(SingleItemRecipe::input), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> ((BlastFurnaceRecipe)recipe).result()), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(AbstractCookingRecipe::experience), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("cookingTime", (Object)400).forGetter(AbstractCookingRecipe::cookingTime), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("slagOutput", (Object)0).forGetter(recipe -> recipe.slagOutput)).apply((Applicative)instance, BlastFurnaceRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, BlastFurnaceRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BlastFurnaceRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BlastFurnaceRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static BlastFurnaceRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int slagOutput = buffer.readVarInt();
            int cookingTime = buffer.readVarInt();
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            float experience = buffer.readFloat();
            return new BlastFurnaceRecipe(ingredient, result, experience, cookingTime, slagOutput);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, BlastFurnaceRecipe recipe) {
            buffer.writeVarInt(recipe.slagOutput);
            buffer.writeVarInt(recipe.cookingTime());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input());
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result());
            buffer.writeFloat(recipe.experience());
        }
    }
}

