/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mods.railcraft.world.item.LocomotiveItem;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.component.LocomotiveColorComponent;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LocomotivePaintingRecipe
extends CustomRecipe {
    @Nullable
    private PlacementInfo placementInfo;
    protected final NonNullList<Optional<Ingredient>> ingredients = NonNullList.withSize((int)9, Optional.empty());

    public LocomotivePaintingRecipe(CraftingBookCategory category) {
        super(category);
        this.ingredients.set(1, Optional.of(Ingredient.of((ItemLike)Items.RED_DYE)));
        this.ingredients.set(4, Optional.of(Ingredient.of((ItemLike)((ItemLike)RailcraftItems.STEAM_LOCOMOTIVE.get()))));
        this.ingredients.set(7, Optional.of(Ingredient.of((ItemLike)Items.BLUE_DYE)));
    }

    private ItemStack getItemStackInRow(CraftingInput craftingInput, int row) {
        int width = craftingInput.width();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < craftingInput.width(); ++i) {
            ItemStack item = craftingInput.getItem(row * width + i);
            if (item.isEmpty()) continue;
            result.add(item);
        }
        return result.size() != 1 ? ItemStack.EMPTY : (ItemStack)result.getFirst();
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        if (craftingInput.height() < 3) {
            return false;
        }
        ItemStack dyePrimary = this.getItemStackInRow(craftingInput, 0);
        if (!(dyePrimary.getItem() instanceof DyeItem)) {
            return false;
        }
        ItemStack loco = this.getItemStackInRow(craftingInput, 1);
        if (!(loco.getItem() instanceof LocomotiveItem)) {
            return false;
        }
        ItemStack dyeSecondary = this.getItemStackInRow(craftingInput, 2);
        return dyeSecondary.getItem() instanceof DyeItem;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        ItemStack dyePrimary = this.getItemStackInRow(craftingInput, 0);
        ItemStack loco = this.getItemStackInRow(craftingInput, 1);
        ItemStack dyeSecondary = this.getItemStackInRow(craftingInput, 2);
        Item item = dyePrimary.getItem();
        if (!(item instanceof DyeItem)) {
            return ItemStack.EMPTY;
        }
        DyeItem primaryItem = (DyeItem)item;
        Item item2 = loco.getItem();
        if (!(item2 instanceof LocomotiveItem)) {
            return ItemStack.EMPTY;
        }
        LocomotiveItem locomotiveItem = (LocomotiveItem)item2;
        Item item3 = dyeSecondary.getItem();
        if (!(item3 instanceof DyeItem)) {
            return ItemStack.EMPTY;
        }
        DyeItem secondaryItem = (DyeItem)item3;
        DyeColor primaryColor = primaryItem.getDyeColor();
        DyeColor secondaryColor = secondaryItem.getDyeColor();
        ItemStack result = new ItemStack((ItemLike)locomotiveItem);
        DataComponentMap components = loco.getComponents();
        result.applyComponents(components);
        LocomotiveItem.setItemColorData(result, primaryColor, secondaryColor);
        return result;
    }

    public RecipeSerializer<LocomotivePaintingRecipe> getSerializer() {
        return (RecipeSerializer)RailcraftRecipeSerializers.LOCOMOTIVE_PAINTING.get();
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.createFromOptionals(this.ingredients);
        }
        return this.placementInfo;
    }

    public List<RecipeDisplay> display() {
        ItemStack result = RailcraftItems.STEAM_LOCOMOTIVE.toStack();
        result.set((DataComponentType)RailcraftDataComponents.LOCOMOTIVE_COLOR.get(), (Object)new LocomotiveColorComponent(DyeColor.RED, DyeColor.BLUE));
        return List.of(new ShapedCraftingRecipeDisplay(3, 3, this.ingredients.stream().map(i -> i.map(Ingredient::display).orElse((SlotDisplay)SlotDisplay.Empty.INSTANCE)).toList(), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(result), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.CRAFTING_TABLE)));
    }
}

