/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;

public abstract class TieRecipe
extends CustomRecipe {
    private final TagKey<Fluid> fluidTag;
    private final ItemStack result;
    protected final NonNullList<Optional<Ingredient>> ingredients;
    @Nullable
    private PlacementInfo placementInfo;

    public TieRecipe(CraftingBookCategory category, TagKey<Fluid> fluidTag, ItemStack result) {
        super(category);
        this.fluidTag = fluidTag;
        this.result = result;
        this.ingredients = NonNullList.withSize((int)6, Optional.empty());
    }

    public final boolean matches(CraftingInput craftingInput, Level level) {
        if (craftingInput.width() != 3 || craftingInput.height() != 2) {
            return false;
        }
        if (!craftingInput.getItem(0).isEmpty() || !craftingInput.getItem(2).isEmpty()) {
            return false;
        }
        ItemStack item = craftingInput.getItem(1);
        if (item.isEmpty()) {
            return false;
        }
        if (!FluidUtil.getFirstStackContained((ItemStack)item).is(this.fluidTag)) {
            return false;
        }
        for (int i = 3; i < 6; ++i) {
            if (this.testBottomIngredients(craftingInput, i)) continue;
            return false;
        }
        return true;
    }

    protected boolean testBottomIngredients(CraftingInput craftingInput, int index) {
        return ((Optional)this.ingredients.get(index)).map(ingredient -> ingredient.test(craftingInput.getItem(index))).orElse(false);
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        FluidStack fluidHandler = FluidUtil.getFirstStackContained((ItemStack)craftingInput.getItem(1));
        if (fluidHandler.getAmount() >= 1000) {
            return this.result.copy();
        }
        return ItemStack.EMPTY;
    }

    public final NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList remainingItems = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        ItemStack[] containerItems = input.items().toArray(new ItemStack[0]);
        ResourceHandler container = VanillaContainerWrapper.of((Container)new SimpleContainer(this, containerItems){

            public void setItem(int slot, ItemStack stack, boolean performSideEffects) {
                this.getItems().set(slot, (Object)stack);
            }
        });
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack item = input.getItem(i);
            if (!item.getCraftingRemainder().isEmpty()) {
                remainingItems.set(i, (Object)item.getCraftingRemainder());
                continue;
            }
            ItemAccess itemAccess = ItemAccess.forHandlerIndex((ResourceHandler)container, (int)i);
            ResourceHandler cap = (ResourceHandler)itemAccess.getCapability(Capabilities.Fluid.ITEM);
            if (cap == null) continue;
            try (Transaction tx = Transaction.openRoot();){
                int extracted;
                FluidResource resource = (FluidResource)cap.getResource(0);
                if (!resource.isEmpty() && (extracted = cap.extract((Resource)resource, 1000, (TransactionContext)tx)) == 1000) {
                    tx.commit();
                }
            }
            remainingItems.set(i, (Object)item.copy());
        }
        return remainingItems;
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.createFromOptionals(this.ingredients);
        }
        return this.placementInfo;
    }

    public List<RecipeDisplay> display() {
        return List.of(new ShapedCraftingRecipeDisplay(3, 2, this.ingredients.stream().map(i -> i.map(Ingredient::display).orElse((SlotDisplay)SlotDisplay.Empty.INSTANCE)).toList(), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.result), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.CRAFTING_TABLE)));
    }
}

