/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeBlock;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.world.level.block.MultiblockBlock;
import mods.railcraft.world.level.block.entity.CrusherBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class CrusherMultiblockBlock
extends MultiblockBlock
implements ChargeBlock {
    public static final Property<Type> TYPE = EnumProperty.create((String)"type", Type.class);
    public static final Property<Boolean> ROTATED = BooleanProperty.create((String)"rotated");
    public static final Property<Boolean> OUTPUT = BooleanProperty.create((String)"output");
    private static final Map<Charge, ChargeBlock.Spec> CHARGE_SPECS = ChargeBlock.Spec.make(Charge.distribution, ChargeBlock.ConnectType.BLOCK, 0.025f, new ChargeStorage.Spec(ChargeStorage.State.DISABLED, 80000, 8000, 1.0f));
    private static final MapCodec<CrusherMultiblockBlock> CODEC = CrusherMultiblockBlock.simpleCodec(CrusherMultiblockBlock::new);

    public CrusherMultiblockBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(TYPE, (Comparable)((Object)Type.NONE))).setValue(ROTATED, (Comparable)Boolean.valueOf(false))).setValue(OUTPUT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends MultiblockBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE, ROTATED, OUTPUT});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CrusherBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.isClientSide() ? null : CrusherMultiblockBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.CRUSHER.get()), CrusherBlockEntity::serverTick);
    }

    @Override
    public Map<Charge, ChargeBlock.Spec> getChargeSpecs(BlockState state, ServerLevel level, BlockPos pos) {
        return CHARGE_SPECS;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Charge.zapEffectProvider().throwSparks(state, level, pos, random, 50);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        this.registerNode(state, level, pos);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!state.is(oldState.getBlock())) {
            this.registerNode(state, (ServerLevel)level, pos);
        }
    }

    public static enum Type implements StringRepresentable
    {
        NONE("none"),
        NORTH("north"),
        NORTH_EAST("north_east"),
        NORTH_WEST("north_west"),
        SOUTH("south"),
        SOUTH_EAST("south_east"),
        SOUTH_WEST("south_west");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

