/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block;

import com.mojang.serialization.MapCodec;
import mods.railcraft.Translations;
import mods.railcraft.integrations.jei.JeiSearchable;
import mods.railcraft.world.level.block.entity.FeedStationBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class FeedStationBlock
extends BaseEntityBlock
implements JeiSearchable {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final MapCodec<FeedStationBlock> CODEC = FeedStationBlock.simpleCodec(FeedStationBlock::new);

    protected FeedStationBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    protected RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult rayTraceResult) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            level.getBlockEntity(pos, (BlockEntityType)RailcraftBlockEntityTypes.FEED_STATION.get()).ifPresent(blockEntity -> serverPlayer.openMenu((MenuProvider)blockEntity, pos));
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new FeedStationBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.isClientSide() ? null : FeedStationBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.FEED_STATION.get()), FeedStationBlockEntity::serverTick);
    }

    protected void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block neighborBlock, @Nullable Orientation orientation, boolean moved) {
        if (!level.isClientSide()) {
            Boolean powered = (Boolean)blockState.getValue((Property)POWERED);
            boolean neighborSignal = level.hasNeighborSignal(blockPos);
            if (powered != neighborSignal) {
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(neighborSignal)), 2);
            }
        }
    }

    @Override
    public Component jeiDescription() {
        return Component.translatable((String)Translations.Jei.FEED_STATION);
    }
}

