/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block;

import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class RailcraftBlockProperties {
    public static UnaryOperator<BlockBehaviour.Properties> detector() {
        return __ -> BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(2.0f, 4.5f).requiresCorrectToolForDrops().sound(SoundType.METAL);
    }

    public static UnaryOperator<BlockBehaviour.Properties> steamBoilerTank() {
        return __ -> BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(5.0f, 6.0f).requiresCorrectToolForDrops().noOcclusion().sound(SoundType.METAL);
    }

    public static UnaryOperator<BlockBehaviour.Properties> fueledFirebox() {
        return __ -> BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(3.5f).requiresCorrectToolForDrops().lightLevel(RailcraftBlockProperties.litBlockEmission(13)).sound(SoundType.METAL);
    }

    public static UnaryOperator<BlockBehaviour.Properties> battery() {
        return __ -> BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f).randomTicks().requiresCorrectToolForDrops().sound(SoundType.METAL);
    }

    public static UnaryOperator<BlockBehaviour.Properties> steelAnvil() {
        return __ -> BlockBehaviour.Properties.of().mapColor(MapColor.METAL).pushReaction(PushReaction.BLOCK).requiresCorrectToolForDrops().strength(5.0f, 2000.0f).sound(SoundType.ANVIL);
    }

    public static BlockBehaviour.Properties ingotBlock(BlockBehaviour.Properties properties) {
        return properties.mapColor(MapColor.METAL).strength(5.0f, 15.0f).sound(SoundType.METAL).requiresCorrectToolForDrops();
    }

    public static BlockBehaviour.Properties oreInGroundStone(BlockBehaviour.Properties properties) {
        return properties.mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(3.0f, 3.0f).requiresCorrectToolForDrops();
    }

    public static BlockBehaviour.Properties oreInGroundDeepslate(BlockBehaviour.Properties properties) {
        return properties.mapColor(MapColor.DEEPSLATE).instrument(NoteBlockInstrument.BASEDRUM).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE).requiresCorrectToolForDrops();
    }

    public static UnaryOperator<BlockBehaviour.Properties> fluidManipulator() {
        return __ -> BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(3.5f).requiresCorrectToolForDrops().sound(SoundType.STONE).noOcclusion();
    }

    public static UnaryOperator<BlockBehaviour.Properties> manipulator() {
        return __ -> BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(3.5f).requiresCorrectToolForDrops().sound(SoundType.STONE);
    }

    public static UnaryOperator<BlockBehaviour.Properties> railSupportBlocks() {
        return __ -> BlockBehaviour.Properties.of().strength(8.0f, 50.0f).sound(SoundType.METAL).noOcclusion();
    }

    public static BlockBehaviour.Properties standardTrack(BlockBehaviour.Properties properties) {
        return properties.noCollision().strength(2.0f, 3.5f).sound(SoundType.METAL);
    }

    public static BlockBehaviour.Properties electricTrack(BlockBehaviour.Properties properties) {
        return RailcraftBlockProperties.standardTrack(properties).randomTicks();
    }

    public static BlockBehaviour.Properties reinforcedTrack(BlockBehaviour.Properties properties) {
        return RailcraftBlockProperties.standardTrack(properties).strength(2.0f, 80.0f);
    }

    public static UnaryOperator<BlockBehaviour.Properties> worldSpike() {
        return __ -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OBSIDIAN).sound(SoundType.STONE);
    }

    public static BlockBehaviour.Properties strengthenedGlass() {
        return BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).sound(SoundType.GLASS).noOcclusion().strength(1.0f, 5.0f).requiresCorrectToolForDrops().isValidSpawn(RailcraftBlockProperties::never).isRedstoneConductor(RailcraftBlockProperties::never).isSuffocating(RailcraftBlockProperties::never).isViewBlocking(RailcraftBlockProperties::never);
    }

    public static BlockBehaviour.Properties ironTank() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).noOcclusion().isValidSpawn(RailcraftBlockProperties::never).strength(1.0f, 5.0f).requiresCorrectToolForDrops().explosionResistance(12.0f);
    }

    public static BlockBehaviour.Properties ironTankGauge() {
        return RailcraftBlockProperties.ironTank().instrument(NoteBlockInstrument.HAT).mapColor(MapColor.NONE).sound(SoundType.GLASS).isRedstoneConductor(RailcraftBlockProperties::never).isSuffocating(RailcraftBlockProperties::never).isViewBlocking(RailcraftBlockProperties::never).lightLevel(LightBlock.LIGHT_EMISSION);
    }

    public static BlockBehaviour.Properties steelTank() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).noOcclusion().isValidSpawn(RailcraftBlockProperties::never).strength(1.5f, 6.0f).requiresCorrectToolForDrops().explosionResistance(15.0f);
    }

    public static BlockBehaviour.Properties steelTankGauge() {
        return RailcraftBlockProperties.steelTank().instrument(NoteBlockInstrument.HAT).mapColor(MapColor.NONE).sound(SoundType.GLASS).isRedstoneConductor(RailcraftBlockProperties::never).isSuffocating(RailcraftBlockProperties::never).isViewBlocking(RailcraftBlockProperties::never).lightLevel(LightBlock.LIGHT_EMISSION);
    }

    public static BlockBehaviour.Properties post() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(2.0f, 3.0f).requiresCorrectToolForDrops().sound(SoundType.METAL);
    }

    private static ToIntFunction<BlockState> litBlockEmission(int light) {
        return blockState -> (Boolean)blockState.getValue((Property)BlockStateProperties.LIT) != false ? light : 0;
    }

    private static Boolean never(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, EntityType<?> entityType) {
        return false;
    }

    private static boolean never(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return false;
    }
}

