/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import java.util.List;
import mods.railcraft.util.BoxBuilder;
import mods.railcraft.util.container.StackFilter;
import mods.railcraft.world.inventory.FeedStationMenu;
import mods.railcraft.world.level.block.FeedStationBlock;
import mods.railcraft.world.level.block.entity.ContainerBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;

public class FeedStationBlockEntity
extends ContainerBlockEntity
implements MenuProvider {
    private static final int AREA = 3;
    private static final int MIN_FEED_INTERVAL = 128;
    private static final int FEED_VARIANCE = 256;
    private static final byte ANIMALS_PER_FOOD = 2;
    private int feedTime;
    private byte feedCounter;
    private int processingTicks;

    public FeedStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.FEED_STATION.get(), blockPos, blockState, 1);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, FeedStationBlockEntity blockEntity) {
        ItemStack feed = blockEntity.getItem(0);
        if (blockEntity.processingTicks++ >= 32 && (feed.isEmpty() || feed.getCount() < feed.getMaxStackSize())) {
            blockEntity.findAdjacentContainers().moveOneItemTo(blockEntity, StackFilter.FEED);
            blockEntity.save();
        }
        feed = blockEntity.getItem(0);
        --blockEntity.feedTime;
        Boolean powered = (Boolean)blockState.getValue((Property)FeedStationBlock.POWERED);
        if (!powered.booleanValue() && !feed.isEmpty() && blockEntity.feedTime <= 0) {
            blockEntity.feedTime = 128 + level.getRandom().nextInt(256);
            AABB box = BoxBuilder.create().at(blockPos).raiseFloor(-1.0).raiseCeiling(2.0).inflateHorizontally(3.0).build();
            List animals = level.getEntitiesOfClass(Animal.class, box);
            for (Animal target : animals) {
                if (!target.isFood(blockEntity.getItem(0)) || !blockEntity.feedAnimal(target)) continue;
                if (blockEntity.feedCounter <= 0) {
                    feed.shrink(1);
                    blockEntity.feedCounter = (byte)2;
                }
                blockEntity.feedCounter = (byte)(blockEntity.feedCounter - 1);
                blockEntity.save();
                break;
            }
        }
    }

    private boolean feedAnimal(Animal animal) {
        if (animal.getAge() == 0 && animal.canFallInLove()) {
            Player player;
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                player = this.getOwner().map(profile -> serverLevel.getServer().getPlayerList().getPlayer(profile.id())).orElse(null);
            } else {
                player = null;
            }
            Player player2 = player;
            animal.setInLove(player2);
            this.level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, animal.getRandomX(1.0), animal.getRandomY() + 0.5, animal.getRandomZ(1.0), 0.0, 0.0, 0.0);
            return true;
        }
        return false;
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        Containers.updateNeighboursAfterDestroy((BlockState)state, (Level)this.level, (BlockPos)pos);
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.feedCounter = input.getByteOr("feedCounter", (byte)0);
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putByte("feedCounter", this.feedCounter);
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new FeedStationMenu(id, inventory, this);
    }
}

