/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import mods.railcraft.api.charge.Charge;
import mods.railcraft.util.container.CombinedVanillaContainerWrapper;
import mods.railcraft.world.inventory.PoweredRollingMachineMenu;
import mods.railcraft.world.level.block.PoweredRollingMachineBlock;
import mods.railcraft.world.level.block.entity.ManualRollingMachineBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import org.jetbrains.annotations.Nullable;

public class PoweredRollingMachineBlockEntity
extends ManualRollingMachineBlockEntity {
    private static final int CHARGE_PER_TICK = 10;
    private final ResourceHandler<ItemResource> itemHandler;

    public PoweredRollingMachineBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.POWERED_ROLLING_MACHINE.get(), blockPos, blockState);
        this.itemHandler = new CombinedVanillaContainerWrapper((Container)this.craftMatrix, (Container)this.getInvResult());
    }

    @Override
    protected void progress() {
        if (this.access().useCharge(10, false)) {
            super.progress();
        }
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)this.getInvResult());
        Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)this.craftMatrix);
        Containers.updateNeighboursAfterDestroy((BlockState)state, (Level)this.level, (BlockPos)pos);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ((PoweredRollingMachineBlock)state.getBlock()).deregisterNode(serverLevel, pos);
        }
    }

    private Charge.Access access() {
        return Charge.distribution.network((ServerLevel)this.level).access(this.blockPos());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return new PoweredRollingMachineMenu(containerId, inventory, this);
    }

    public ResourceHandler<ItemResource> getItemCap(@Nullable Direction side) {
        return this.itemHandler;
    }
}

