/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import com.google.common.primitives.Bytes;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import mods.railcraft.api.core.BlockEntityLike;
import mods.railcraft.api.core.NetworkSerializable;
import mods.railcraft.api.core.Ownable;
import mods.railcraft.world.module.BlockModuleProvider;
import mods.railcraft.world.module.Module;
import mods.railcraft.world.module.ModuleDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.NameAndId;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.network.connection.ConnectionType;
import org.jetbrains.annotations.Nullable;

public abstract class RailcraftBlockEntity
extends BlockEntity
implements NetworkSerializable,
Ownable,
BlockEntityLike,
BlockModuleProvider {
    protected final ModuleDispatcher moduleDispatcher = new ModuleDispatcher();
    @Nullable
    private NameAndId owner;
    @Nullable
    private Component customName;

    public RailcraftBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public final CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        if (this.level == null) {
            return tag;
        }
        FriendlyByteBuf friendlyBuf = new FriendlyByteBuf(Unpooled.buffer());
        RegistryFriendlyByteBuf packetBuffer = new RegistryFriendlyByteBuf((ByteBuf)friendlyBuf, this.level.registryAccess(), ConnectionType.OTHER);
        this.writeToBuf(packetBuffer);
        byte[] syncData = new byte[packetBuffer.readableBytes()];
        packetBuffer.readBytes(syncData);
        tag.putByteArray("sync", syncData);
        return tag;
    }

    public void handleUpdateTag(ValueInput input) {
        if (this.level == null) {
            return;
        }
        input.read("sync", Codec.BYTE.listOf()).ifPresent(bytes -> {
            byte[] syncData = Bytes.toArray((Collection)bytes);
            FriendlyByteBuf friendlyBuf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])syncData));
            RegistryFriendlyByteBuf packetBuffer = new RegistryFriendlyByteBuf((ByteBuf)friendlyBuf, this.level.registryAccess(), ConnectionType.OTHER);
            this.readFromBuf(packetBuffer);
        });
    }

    public void onDataPacket(Connection net, ValueInput valueInput) {
        this.handleUpdateTag(valueInput);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf out) {
        out.writeNullable((Object)this.owner, (friendlyByteBuf, gameProfile) -> {
            friendlyByteBuf.writeUUID(gameProfile.id());
            friendlyByteBuf.writeUtf(gameProfile.name());
        });
        out.writeNullable((Object)this.customName, (friendlyByteBuf, component) -> ComponentSerialization.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)friendlyByteBuf), component));
        this.moduleDispatcher.writeToBuf(out);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf in) {
        this.owner = (NameAndId)in.readNullable(friendlyByteBuf -> {
            UUID id = friendlyByteBuf.readUUID();
            String name = friendlyByteBuf.readUtf();
            return new NameAndId(id, name);
        });
        this.customName = (Component)in.readNullable(friendlyByteBuf -> (Component)ComponentSerialization.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)friendlyByteBuf)));
        this.moduleDispatcher.readFromBuf(in);
    }

    @Override
    public BlockPos blockPos() {
        return this.getBlockPos();
    }

    @Override
    @Nullable
    public Level level() {
        return this.level;
    }

    @Override
    public void syncToClient() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ClientboundBlockEntityDataPacket packet = this.getUpdatePacket();
            serverLevel.players().forEach(player -> player.connection.send((Packet)packet));
        }
    }

    @Override
    public void save() {
        this.setChanged();
    }

    @Override
    public <T extends Module> Optional<T> getModule(Class<T> type) {
        return this.moduleDispatcher.getModule(type);
    }

    @Override
    public boolean isStillValid(Player player) {
        return RailcraftBlockEntity.isStillValid(this, player, 64);
    }

    @Override
    public final void setOwner(@Nullable NameAndId profile) {
        this.owner = profile;
    }

    @Override
    public final Optional<NameAndId> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public final boolean isOwner(NameAndId gameProfile) {
        return gameProfile.equals((Object)this.owner);
    }

    public final boolean isOwnerOrOperator(NameAndId gameProfile) {
        ServerLevel serverLevel;
        Level level;
        return this.isOwner(gameProfile) || (level = this.level) instanceof ServerLevel && (serverLevel = (ServerLevel)level).getServer().getPlayerList().isOp(gameProfile);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.storeNullable("owner", NameAndId.CODEC, (Object)this.owner);
        output.storeNullable("customName", ComponentSerialization.CODEC, (Object)this.customName);
        output.putChild("modules", (ValueIOSerializable)this.moduleDispatcher);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.owner = input.read("owner", NameAndId.CODEC).orElse(null);
        this.customName = input.read("customName", ComponentSerialization.CODEC).orElse(null);
        input.readChild("modules", (ValueIOSerializable)this.moduleDispatcher);
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    protected void setCustomName(@Nullable Component name) {
        this.customName = name;
        this.syncToClient();
    }

    public Component getName() {
        return this.hasCustomName() ? this.customName : this.getBlockState().getBlock().getName();
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Override
    public final BlockEntity asBlockEntity() {
        return this;
    }

    public static boolean isStillValid(BlockEntity blockEntity, Player player, int maxDistance) {
        BlockPos pos = blockEntity.getBlockPos();
        double distance = player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        return !blockEntity.isRemoved() && blockEntity.getLevel().getBlockEntity(pos).equals(blockEntity) && distance <= (double)maxDistance;
    }
}

