/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.detector;

import java.util.List;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.detector.DetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AgeDetectorBlockEntity
extends DetectorBlockEntity {
    public AgeDetectorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.AGE_DETECTOR.get(), blockPos, blockState);
    }

    @Override
    protected int testCarts(List<AbstractMinecart> minecarts) {
        for (AbstractMinecart cart : minecarts) {
            List passengers = cart.getPassengers();
            if (passengers.stream().anyMatch(entity -> {
                AgeableMob ageableMob;
                return entity instanceof AgeableMob && (ageableMob = (AgeableMob)entity).isBaby();
            })) {
                return 0;
            }
            if (passengers.isEmpty()) continue;
            return 15;
        }
        return 0;
    }
}

