/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.detector;

import mods.railcraft.api.core.Lockable;
import mods.railcraft.world.level.block.entity.LockableSwitchTrackActuatorBlockEntity;
import mods.railcraft.world.level.block.entity.detector.DetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.players.NameAndId;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class SecureDetectorBlockEntity
extends DetectorBlockEntity
implements Lockable {
    private LockableSwitchTrackActuatorBlockEntity.Lock lock = LockableSwitchTrackActuatorBlockEntity.Lock.UNLOCKED;

    protected SecureDetectorBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public LockableSwitchTrackActuatorBlockEntity.Lock getLock() {
        return this.lock;
    }

    public void setLock(@Nullable NameAndId gameProfile) {
        this.lock = gameProfile == null ? LockableSwitchTrackActuatorBlockEntity.Lock.UNLOCKED : LockableSwitchTrackActuatorBlockEntity.Lock.LOCKED;
        this.setOwner(gameProfile);
    }

    @Override
    public boolean isLocked() {
        return this.lock == LockableSwitchTrackActuatorBlockEntity.Lock.LOCKED;
    }

    @Override
    public boolean canAccess(NameAndId gameProfile) {
        return !this.isLocked() || this.isOwnerOrOperator(gameProfile);
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.store("lock", LockableSwitchTrackActuatorBlockEntity.Lock.CODEC, (Object)this.lock);
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.lock = input.read("lock", LockableSwitchTrackActuatorBlockEntity.Lock.CODEC).orElse(LockableSwitchTrackActuatorBlockEntity.Lock.UNLOCKED);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        super.writeToBuf(data);
        data.writeEnum((Enum)this.lock);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.lock = (LockableSwitchTrackActuatorBlockEntity.Lock)data.readEnum(LockableSwitchTrackActuatorBlockEntity.Lock.class);
    }
}

