/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.detector;

import java.util.List;
import mods.railcraft.world.inventory.detector.SheepDetectorMenu;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.detector.FilterDetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SheepDetectorBlockEntity
extends FilterDetectorBlockEntity {
    public SheepDetectorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.SHEEP_DETECTOR.get(), blockPos, blockState, 1);
    }

    @Override
    protected int testCarts(List<AbstractMinecart> minecarts) {
        ItemStack dyeItem = this.invFilters.getItem(0);
        for (AbstractMinecart cart : minecarts) {
            List passengers = cart.getPassengers();
            if (!passengers.stream().filter(Sheep.class::isInstance).map(Sheep.class::cast).anyMatch(sheep -> !sheep.isBaby() && !sheep.isSheared() && (dyeItem.isEmpty() || sheep.getColor() == DyeColor.getColor((ItemStack)dyeItem)))) continue;
            return 15;
        }
        return 0;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new SheepDetectorMenu(id, inventory, this);
    }
}

