/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.detector;

import java.util.List;
import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.api.util.EnumUtil;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.gui.button.ButtonState;
import mods.railcraft.util.fluids.AdvancedFluidHandler;
import mods.railcraft.world.inventory.detector.TankDetectorMenu;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.detector.FilterDetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import org.jetbrains.annotations.Nullable;

public class TankDetectorBlockEntity
extends FilterDetectorBlockEntity {
    private Mode mode = Mode.VOID;

    public TankDetectorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.TANK_DETECTOR.get(), blockPos, blockState, 1);
    }

    public FluidStack getFilterFluid() {
        ItemStack item = this.invFilters.getItem(0);
        if (item.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return FluidUtil.getFirstStackContained((ItemStack)item);
    }

    @Override
    protected int testCarts(List<AbstractMinecart> minecarts) {
        for (AbstractMinecart cart : minecarts) {
            ResourceHandler fluidHandler = (ResourceHandler)cart.getCapability(Capabilities.Fluid.ENTITY, null);
            if (fluidHandler == null) continue;
            AdvancedFluidHandler tank = new AdvancedFluidHandler((ResourceHandler<FluidResource>)fluidHandler);
            boolean liquidMatches = false;
            FluidStack filterFluid = this.getFilterFluid();
            FluidStack tankLiquid = FluidUtil.getStack((ResourceHandler)tank, (int)0);
            if (filterFluid.isEmpty()) {
                liquidMatches = true;
            } else if (FluidStack.isSameFluidSameComponents((FluidStack)filterFluid, (FluidStack)tankLiquid)) {
                liquidMatches = true;
            } else if (tank.canPutFluid(FluidResource.of((FluidStack)filterFluid), 1)) {
                liquidMatches = true;
            }
            boolean quantityMatches = false;
            switch (this.mode.ordinal()) {
                case 0: {
                    quantityMatches = true;
                    break;
                }
                case 1: {
                    if (!filterFluid.isEmpty() && tank.isTankEmpty(filterFluid)) {
                        quantityMatches = true;
                        break;
                    }
                    if (!filterFluid.isEmpty() || !tank.areTanksEmpty()) break;
                    quantityMatches = true;
                    break;
                }
                case 2: {
                    if (!filterFluid.isEmpty() && tank.getFluidQty(filterFluid) > 0) {
                        quantityMatches = true;
                        break;
                    }
                    if (!filterFluid.isEmpty() || !tank.isFluidInTank()) break;
                    quantityMatches = true;
                    break;
                }
                case 3: {
                    if (!filterFluid.isEmpty() && tank.isTankFull(filterFluid)) {
                        quantityMatches = true;
                        break;
                    }
                    if (!filterFluid.isEmpty() || !tank.areTanksFull()) break;
                    quantityMatches = true;
                    break;
                }
                default: {
                    float level;
                    float f = level = !filterFluid.isEmpty() ? tank.getFluidLevel(filterFluid) : tank.getFluidLevel();
                    if (this.mode == Mode.ANALOG) {
                        return (int)(15.0f * level);
                    }
                    quantityMatches = switch (this.mode.ordinal()) {
                        case 4 -> {
                            if (level >= 0.25f) {
                                yield true;
                            }
                            yield false;
                        }
                        case 5 -> {
                            if (level >= 0.5f) {
                                yield true;
                            }
                            yield false;
                        }
                        case 6 -> {
                            if (level >= 0.75f) {
                                yield true;
                            }
                            yield false;
                        }
                        case 7 -> {
                            if (level < 0.25f) {
                                yield true;
                            }
                            yield false;
                        }
                        case 8 -> {
                            if (level < 0.5f) {
                                yield true;
                            }
                            yield false;
                        }
                        case 9 -> {
                            if (level < 0.75f) {
                                yield true;
                            }
                            yield false;
                        }
                        case 10 -> {
                            if (level < 1.0f) {
                                yield true;
                            }
                            yield false;
                        }
                        default -> false;
                    };
                }
            }
            return liquidMatches && quantityMatches ? 15 : 0;
        }
        return 0;
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.store("mode", Mode.CODEC, (Object)this.mode);
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.mode = input.read("mode", Mode.CODEC).orElse(Mode.VOID);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        super.writeToBuf(data);
        data.writeEnum((Enum)this.mode);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.mode = (Mode)data.readEnum(Mode.class);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new TankDetectorMenu(id, inventory, this);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public static enum Mode implements ButtonState<Mode>,
    StringRepresentable
    {
        VOID("void", "L = *"),
        EMPTY("empty", "L = 0%"),
        NOT_EMPTY("not_empty", "L > 0%"),
        FULL("full", "L = 100%"),
        QUARTER("quarter", "L >= 25%"),
        HALF("half", "L >= 50%"),
        MOST("most", "L >= 75%"),
        LESS_THAN_QUARTER("less_than_quarter", "L < 25%"),
        LESS_THAN_HALF("less_than_half", "L < 50%"),
        LESS_THAN_MOST("less_than_most", "L < 75%"),
        LESS_THAN_FULL("less_than_full", "L < 100%"),
        ANALOG("analog", "L = ~");

        private static final StringRepresentable.EnumCodec<Mode> CODEC;
        private final String name;
        private final String label;

        private Mode(String name, String label) {
            this.name = name;
            this.label = label;
        }

        @Override
        public Component label() {
            return Component.literal((String)this.label);
        }

        @Override
        public TexturePosition texturePosition() {
            return ButtonTexture.LARGE_BUTTON;
        }

        @Override
        public Optional<Component> tooltip() {
            return Optional.of(Component.translatable((String)Translations.makeKey("screen", "tank_detector." + this.name)));
        }

        @Override
        public Mode next() {
            return (Mode)EnumUtil.next((Enum)this, (Enum[])Mode.values());
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Mode::values);
        }
    }
}

