/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.manipulator;

import java.util.Optional;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.inventory.FluidManipulatorMenu;
import mods.railcraft.world.level.block.entity.manipulator.ManipulatorBlockEntity;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.level.material.TankManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import org.jetbrains.annotations.Nullable;

public abstract class FluidManipulatorBlockEntity
extends ManipulatorBlockEntity
implements WorldlyContainer,
MenuProvider {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_PROCESSING = 1;
    protected static final int SLOT_OUTPUT = 2;
    protected static final int[] SLOTS = ContainerTools.buildSlotArray(0, 3);
    protected final AdvancedContainer fluidFilterContainer = new AdvancedContainer(1).listener(this).phantom();
    protected final TankManager tankManager = new TankManager(new StandardTank[0]);
    protected final StandardTank tank = StandardTank.ofBuckets(32);
    private FluidTools.ProcessState processState = FluidTools.ProcessState.RESET;
    private int fluidProcessingTimer;

    protected FluidManipulatorBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
        this.setContainerSize(3);
        this.tankManager.add(this.tank);
        this.tank.setValidator(fluidResource -> this.getFilterFluid().map(arg_0 -> ((FluidResource)fluidResource).matches(arg_0)).orElse(true));
        this.tank.changeCallback(this::tankChanged);
    }

    protected void tankChanged() {
        this.syncToClient();
        this.setChanged();
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }

    public AdvancedContainer getFluidFilter() {
        return this.fluidFilterContainer;
    }

    public Optional<FluidStack> getFilterFluid() {
        ItemStack item = this.fluidFilterContainer.getItem(0);
        if (item.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(FluidUtil.getFirstStackContained((ItemStack)item));
    }

    public FluidStack getFluidHandled() {
        return this.getFilterFluid().orElseGet(this.tank::getFluidStack);
    }

    @Nullable
    protected static ResourceHandler<FluidResource> getCartFluidHandler(AbstractMinecart cart, Direction direction) {
        return (ResourceHandler)cart.getCapability(Capabilities.Fluid.ENTITY, (Object)direction);
    }

    public boolean use(Player player, InteractionHand hand) {
        return FluidTools.interactWithFluidHandler(player, hand, (ResourceHandler<FluidResource>)this.tank);
    }

    @Override
    public boolean canHandleCart(AbstractMinecart cart) {
        return cart.getCapability(Capabilities.Fluid.ENTITY, (Object)this.getFacing().getOpposite()) != null && super.canHandleCart(cart);
    }

    @Override
    protected void upkeep() {
        super.upkeep();
        ContainerTools.dropIfInvalid(this.level, this.getBlockPos(), this, 0);
        ContainerTools.drop(this.level, this.getBlockPos(), this, 1, FluidTools::isFluidHandler);
        ContainerTools.drop(this.level, this.getBlockPos(), this, 2, FluidTools::isFluidHandler);
        if (this.fluidProcessingTimer++ >= 8) {
            this.fluidProcessingTimer = 0;
            this.processState = FluidTools.processContainer(this, this.tank, this.getProcessType(), this.processState);
        }
    }

    protected abstract FluidTools.ProcessType getProcessType();

    @Override
    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (slot == 0) {
            if (!FluidTools.isFluidHandler(stack)) {
                return false;
            }
            if (FluidTools.isEmptyContainer(stack)) {
                return true;
            }
            return this.getFilterFluid().map(FluidStack::getFluid).map(fluid -> FluidTools.containsFluid(stack, fluid)).orElse(true);
        }
        return false;
    }

    public int[] getSlotsForFace(Direction side) {
        return SLOTS;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStackIn);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return index == 2;
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new FluidManipulatorMenu(id, inventory, this);
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.store("processState", FluidTools.ProcessState.CODEC, (Object)this.processState);
        output.putChild("tankManager", (ValueIOSerializable)this.tankManager);
        output.putChild("invFilter", (ValueIOSerializable)this.getFluidFilter());
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.processState = input.read("processState", FluidTools.ProcessState.CODEC).orElse(FluidTools.ProcessState.RESET);
        input.readChild("tankManager", (ValueIOSerializable)this.tankManager);
        input.readChild("invFilter", (ValueIOSerializable)this.getFluidFilter());
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        super.writeToBuf(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.tankManager.readPacketData(data);
    }

    public ResourceHandler<FluidResource> getFluidCap(@Nullable Direction side) {
        return this.tankManager;
    }
}

