/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.manipulator;

import java.util.stream.Stream;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.util.Predicates;
import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.manipulator.FluidManipulatorBlockEntity;
import mods.railcraft.world.level.block.entity.manipulator.ManipulatorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class FluidUnloaderBlockEntity
extends FluidManipulatorBlockEntity {
    private static final int TRANSFER_RATE = 80;
    private static final Direction[] PUSH_TO = (Direction[])Stream.of(Direction.values()).filter(direction -> direction != Direction.UP).toArray(Direction[]::new);

    public FluidUnloaderBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.FLUID_UNLOADER.get(), blockPos, blockState);
    }

    @Override
    protected void upkeep() {
        super.upkeep();
        this.tankManager.push(FluidTools.findNeighbors(this.level, this.getBlockPos(), Predicates.notOfType(FluidUnloaderBlockEntity.class), PUSH_TO), 0, 80);
    }

    @Override
    protected FluidTools.ProcessType getProcessType() {
        return FluidTools.ProcessType.FILL_ONLY;
    }

    @Override
    protected void processCart(AbstractMinecart cart) {
        ResourceHandler<FluidResource> tankCart = FluidUnloaderBlockEntity.getCartFluidHandler(cart, Direction.DOWN);
        if (tankCart != null) {
            Integer transferRate = (Integer)RailcraftConfig.SERVER.tankCartFluidTransferRate.get();
            int moved = ResourceHandlerUtil.move(tankCart, (ResourceHandler)this.tank, __ -> true, (int)transferRate, null);
            this.setProcessing(moved > 0);
        }
    }

    @Override
    protected boolean hasWorkForCart(AbstractMinecart cart) {
        ResourceHandler<FluidResource> cartFluidHandler = FluidUnloaderBlockEntity.getCartFluidHandler(cart, Direction.DOWN);
        if (cartFluidHandler == null) {
            return false;
        }
        if (this.getRedstoneMode() == ManipulatorBlockEntity.RedstoneMode.IMMEDIATE) {
            return false;
        }
        try (Transaction tx = Transaction.openRoot();){
            if (this.getFilterFluid().map(fluid -> cartFluidHandler.extract((Resource)FluidResource.of((FluidStack)fluid), fluid.getAmount(), (TransactionContext)tx) == 0).orElse(false).booleanValue()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = cartFluidHandler.extract((Resource)((FluidResource)cartFluidHandler.getResource(0)), 1, (TransactionContext)tx) > 0;
            return bl;
        }
    }
}

