/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.signal;

import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.signal.SingleSignalReceiver;
import mods.railcraft.api.signal.entity.SignalReceiverEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;

public class DistantSignalBlockEntity
extends AbstractSignalBlockEntity
implements SignalReceiverEntity {
    private final SingleSignalReceiver signalReceiver = new SingleSignalReceiver(this, this::syncToClient, __ -> this.level.getLightEngine().checkBlock(this.getBlockPos()));

    public DistantSignalBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.DISTANT_SIGNAL.get(), blockPos, blockState);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide()) {
            this.signalReceiver.refresh();
        }
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        this.blockRemoved();
    }

    private void blockRemoved() {
        this.signalReceiver.destroy();
    }

    @Override
    public SingleSignalReceiver getSignalReceiver() {
        return this.signalReceiver;
    }

    @Override
    public SignalAspect getPrimarySignalAspect() {
        return this.signalReceiver.getPrimarySignalAspect();
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putChild("signalReceiver", (ValueIOSerializable)this.signalReceiver);
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        input.readChild("signalReceiver", (ValueIOSerializable)this.signalReceiver);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        super.writeToBuf(data);
        this.signalReceiver.writeToBuf(data);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.signalReceiver.readFromBuf(data);
    }
}

