/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.tank;

import mods.railcraft.world.level.block.entity.tank.TankBlockEntity;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class ValveFluidHandler
implements ResourceHandler<FluidResource> {
    private final TankBlockEntity blockEntity;
    private final TankBlockEntity master;

    public ValveFluidHandler(TankBlockEntity blockEntity, TankBlockEntity master) {
        this.blockEntity = blockEntity;
        this.master = master;
    }

    private ResourceHandler<FluidResource> getDelegate() {
        return this.master.getModule().getTank();
    }

    private boolean isFillable() {
        return this.blockEntity.getBlockPos().getY() - this.master.getBlockPos().getY() > 0;
    }

    private boolean isDrainable() {
        return this.blockEntity.getBlockPos().getY() - this.master.getBlockPos().getY() <= 1;
    }

    public int size() {
        return this.getDelegate().size();
    }

    public FluidResource getResource(int index) {
        return (FluidResource)this.getDelegate().getResource(index);
    }

    public long getAmountAsLong(int index) {
        return this.getDelegate().getAmountAsLong(index);
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        return this.getDelegate().getCapacityAsLong(index, (Resource)resource);
    }

    public boolean isValid(int index, FluidResource resource) {
        return this.getDelegate().isValid(index, (Resource)resource);
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (!this.isFillable()) {
            return 0;
        }
        return this.getDelegate().insert(index, (Resource)resource, amount, transaction);
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (!this.isDrainable()) {
            return 0;
        }
        return this.getDelegate().extract(index, (Resource)resource, amount, transaction);
    }
}

