/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import java.util.List;
import java.util.function.Predicate;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.container.manipulator.SlotAccessor;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.container.StackFilter;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.inventory.DumpingTrackMenu;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import org.jetbrains.annotations.Nullable;

public class DumpingTrackBlockEntity
extends RailcraftBlockEntity
implements MenuProvider {
    private static final int ITEM_DROP_INTERVAL = 16;
    private static final List<Direction> DIRECTION = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN);
    private final AdvancedContainer cartFilter = new AdvancedContainer(3).listener(x -> this.setChanged()).phantom();
    private final AdvancedContainer itemFilter = new AdvancedContainer(9).listener(x -> this.setChanged()).phantom();
    private final Predicate<ItemStack> itemMatcher = StackFilter.anyMatch(this.itemFilter);
    private int ticksSinceLastDrop = 0;

    public DumpingTrackBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.DUMPING_TRACK.get(), blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, DumpingTrackBlockEntity blockEntity) {
        ++blockEntity.ticksSinceLastDrop;
    }

    @Nullable
    private static BlockEntity getBlockEntityAround(Level level, BlockPos pos) {
        for (Direction direction : DIRECTION) {
            BlockEntity blockEntity = level.getBlockEntity(pos.relative(direction));
            if (blockEntity == null || level.getCapability(Capabilities.Item.BLOCK, blockEntity.getBlockPos(), null) == null) continue;
            return blockEntity;
        }
        return null;
    }

    public AdvancedContainer getCartFilter() {
        return this.cartFilter;
    }

    public AdvancedContainer getItemFilter() {
        return this.itemFilter;
    }

    public void minecartPassed(AbstractMinecart cart, boolean powered) {
        boolean sameCart;
        if (powered) {
            return;
        }
        if (!this.cartFilter.isEmpty() && !(sameCart = this.cartFilter.stream().anyMatch(slot -> slot.is(cart.getPickResult().getItem())))) {
            return;
        }
        if (!cart.getPassengers().isEmpty() && this.tryDumpRider(cart)) {
            return;
        }
        this.tryDumpInventory(cart);
    }

    private boolean tryDumpRider(AbstractMinecart cart) {
        MinecartUtil.removePassengers(cart);
        return true;
    }

    private void tryDumpInventory(AbstractMinecart cart) {
        if (this.ticksSinceLastDrop < 16) {
            return;
        }
        ResourceHandler itemHandler = (ResourceHandler)cart.getCapability(Capabilities.Item.ENTITY);
        if (itemHandler != null) {
            ContainerManipulator<SlotAccessor> cartInv = ContainerManipulator.of((ResourceHandler<ItemResource>)itemHandler);
            if (!cartInv.hasItems()) {
                return;
            }
            this.ticksSinceLastDrop = 0;
            BlockEntity blockEntity = DumpingTrackBlockEntity.getBlockEntityAround(this.level, this.blockPos());
            if (blockEntity == null) {
                BlockPos below = this.blockPos().below();
                if (this.itemFilter.isEmpty()) {
                    cartInv.streamItems().forEach(itemStack -> Containers.dropItemStack((Level)this.level, (double)below.getX(), (double)below.getY(), (double)below.getZ(), (ItemStack)itemStack));
                } else {
                    cartInv.streamItems().filter(this.itemMatcher).forEach(itemStack -> Containers.dropItemStack((Level)this.level, (double)below.getX(), (double)below.getY(), (double)below.getZ(), (ItemStack)itemStack));
                }
                return;
            }
            ResourceHandler itemHandlerBlockEntity = (ResourceHandler)this.level.getCapability(Capabilities.Item.BLOCK, blockEntity.getBlockPos(), null);
            if (itemHandlerBlockEntity != null) {
                ContainerManipulator<SlotAccessor> blockInv = ContainerManipulator.of((ResourceHandler<ItemResource>)itemHandlerBlockEntity);
                cartInv.moveOneItemStackTo(blockInv);
            }
        }
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putChild("cartFilter", (ValueIOSerializable)this.cartFilter);
        output.putChild("itemFilter", (ValueIOSerializable)this.itemFilter);
        output.putInt("ticksSinceLastDrop", this.ticksSinceLastDrop);
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        input.readChild("cartFilter", (ValueIOSerializable)this.cartFilter);
        input.readChild("itemFilter", (ValueIOSerializable)this.itemFilter);
        this.ticksSinceLastDrop = input.getIntOr("ticksSinceLastDrop", 0);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new DumpingTrackMenu(id, inventory, this);
    }
}

