/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import mods.railcraft.world.level.block.ForceTrackEmitterBlock;
import mods.railcraft.world.level.block.entity.ForceTrackEmitterBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.track.ForceTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public final class ForceTrackBlockEntity
extends RailcraftBlockEntity {
    @Nullable
    private ForceTrackEmitterBlockEntity emitter;
    @Nullable
    private BlockPos emitterPos;

    public ForceTrackBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.FORCE_TRACK.get(), blockPos, blockState);
    }

    public void neighborChanged() {
        this.emitter.notifyTrackChange();
    }

    public void setEmitter(ForceTrackEmitterBlockEntity emitter) {
        this.emitter = emitter;
        this.emitterPos = emitter.getBlockPos();
        this.setOwner(emitter.getOwner().orElse(null));
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue(ForceTrackBlock.COLOR, (Comparable)((DyeColor)emitter.getBlockState().getValue(ForceTrackEmitterBlock.COLOR))));
    }

    public void onLoad() {
        super.onLoad();
        if (this.emitterPos == null) {
            this.emitter = null;
            return;
        }
        this.emitter = this.level.getBlockEntity(this.emitterPos, (BlockEntityType)RailcraftBlockEntityTypes.FORCE_TRACK_EMITTER.get()).orElse(null);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        Level level;
        super.preRemoveSideEffects(pos, state);
        if (this.emitter != null) {
            this.emitter.clearTracks(this.getBlockPos());
        }
        if ((level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ForceTrackBlock block = (ForceTrackBlock)state.getBlock();
            if (block.getTrackType().isElectric()) {
                block.deregisterNode(serverLevel, pos);
            }
        }
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.storeNullable("emitterPos", BlockPos.CODEC, (Object)this.emitterPos);
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.emitterPos = input.read("emitterPos", BlockPos.CODEC).orElse(null);
    }
}

