/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.level.block.entity.track.LockingTrackBlockEntity;
import mods.railcraft.world.level.block.track.TrackBlock;
import mods.railcraft.world.level.block.track.outfitted.LockingModeController;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class HoldingLockingProfile
implements LockingModeController {
    protected static final float DIR_THRESHOLD = 0.01f;
    protected boolean launchForward = true;
    private final LockingTrackBlockEntity lockingTrack;

    public HoldingLockingProfile(LockingTrackBlockEntity lockingTrack) {
        this.lockingTrack = lockingTrack;
    }

    @Override
    public void locked(AbstractMinecart cart) {
        this.setLaunchDirection(cart);
    }

    @Override
    public void passed(AbstractMinecart cart) {
        this.setLaunchDirection(cart);
    }

    @Override
    public void released(AbstractMinecart cart) {
        RailShape railShape = TrackBlock.getRailShapeRaw(this.lockingTrack.getBlockState());
        cart.setDeltaMovement(this.applyBoost(RailShapeUtil.isNorthSouth(railShape) ? Direction.Axis.Z : Direction.Axis.X, cart.getDeltaMovement()));
    }

    private Vec3 applyBoost(Direction.Axis axis, Vec3 deltaMovement) {
        double boost;
        double speed = MinecartUtil.getCartSpeedUncapped(deltaMovement);
        double d = boost = speed > 0.005 ? Math.abs(deltaMovement.get(axis)) / speed * 0.06 : 0.04;
        Vec3 newDeltaMovement = this.launchForward ? deltaMovement.add(axis == Direction.Axis.X ? boost : 0.0, 0.0, axis == Direction.Axis.Z ? boost : 0.0) : deltaMovement.subtract(axis == Direction.Axis.X ? boost : 0.0, 0.0, axis == Direction.Axis.Z ? boost : 0.0);
        return newDeltaMovement;
    }

    protected void setLaunchDirection(AbstractMinecart cart) {
        RailShape railShape = TrackBlock.getRailShapeRaw(this.lockingTrack.getBlockState());
        Vec3 deltaMovement = cart.getDeltaMovement();
        if (MinecartUtil.getCartSpeedUncapped(deltaMovement) > (double)0.01f) {
            this.launchForward = RailShapeUtil.isNorthSouth(railShape) ? deltaMovement.z() > 0.0 : deltaMovement.x() > 0.0;
        }
    }

    @Override
    public void serialize(ValueOutput valueOutput) {
        valueOutput.putBoolean("launchForward", this.launchForward);
    }

    @Override
    public void deserialize(ValueInput valueInput) {
        this.launchForward = valueInput.getBooleanOr("launchForward", true);
    }
}

