/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.worldspike;

import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.UUID;
import mods.railcraft.particle.ChunkLoaderParticleOptions;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.worldspike.WorldSpikeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.world.chunk.LoadingValidationCallback;
import net.neoforged.neoforge.common.world.chunk.TicketHelper;
import net.neoforged.neoforge.common.world.chunk.TicketSet;
import org.slf4j.Logger;

public class WorldSpikeBlockEntity
extends RailcraftBlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();

    public WorldSpikeBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.WORLD_SPIKE.get(), blockPos, blockState);
    }

    protected WorldSpikeBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ((WorldSpikeBlock)state.getBlock()).removeChunks(serverLevel, pos);
        }
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, WorldSpikeBlockEntity blockEntity) {
        WorldSpikeBlockEntity.spawnParticle((ServerLevel)level, blockPos);
    }

    public static void spawnParticle(ServerLevel level, BlockPos blockPos) {
        RandomSource random = level.random;
        ChunkPos chunkPos = new ChunkPos(blockPos);
        for (int x = chunkPos.x - 1; x <= chunkPos.x + 1; ++x) {
            for (int z = chunkPos.z - 1; z <= chunkPos.z + 1; ++z) {
                int xCorner = x * 16;
                int zCorner = z * 16;
                double yCorner = blockPos.getY() - 8;
                if (!random.nextBoolean()) continue;
                double xParticle = (float)xCorner + random.nextFloat() * 16.0f;
                double yParticle = yCorner + (double)(random.nextFloat() * 16.0f);
                double zParticle = (float)zCorner + random.nextFloat() * 16.0f;
                Vec3 dest = new Vec3((double)blockPos.getX() + 0.1, (double)blockPos.getY(), (double)blockPos.getZ() + 0.1);
                level.sendParticles((ParticleOptions)new ChunkLoaderParticleOptions(dest), xParticle, yParticle, zParticle, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static class RailcraftValidationTicket
    implements LoadingValidationCallback {
        public void validateTickets(ServerLevel level, TicketHelper ticketHelper) {
            int tickingTicketCount;
            int ticketCount;
            TicketSet value;
            Object key;
            for (Map.Entry entry : ticketHelper.getBlockTickets().entrySet()) {
                key = (BlockPos)entry.getKey();
                value = (TicketSet)entry.getValue();
                ticketCount = value.normal().size();
                tickingTicketCount = value.naturalSpawning().size();
                BlockEntity be = level.getBlockEntity(key);
                if (be instanceof WorldSpikeBlockEntity) {
                    LOGGER.info("Allowing {} chunk tickets and {} ticking chunk tickets to be reinstated for position: {}.", new Object[]{ticketCount, tickingTicketCount, key});
                    continue;
                }
                ticketHelper.removeAllTickets(key);
                LOGGER.info("Removing {} chunk tickets and {} ticking chunk tickets for no longer valid position: {}.", new Object[]{ticketCount, tickingTicketCount, key});
            }
            for (Map.Entry entry : ticketHelper.getEntityTickets().entrySet()) {
                key = (UUID)entry.getKey();
                value = (TicketSet)entry.getValue();
                ticketCount = value.normal().size();
                tickingTicketCount = value.naturalSpawning().size();
                LOGGER.info("Allowing {} chunk tickets and {} ticking chunk tickets to be reinstated for entity: {}.", new Object[]{ticketCount, tickingTicketCount, key});
            }
        }
    }
}

