/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.manipulator;

import com.mojang.serialization.MapCodec;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.manipulator.FluidLoaderBlockEntity;
import mods.railcraft.world.level.block.entity.manipulator.ManipulatorBlockEntity;
import mods.railcraft.world.level.block.manipulator.FluidManipulatorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FluidLoaderBlock
extends FluidManipulatorBlock<FluidLoaderBlockEntity> {
    private static final MapCodec<FluidLoaderBlock> CODEC = FluidLoaderBlock.simpleCodec(FluidLoaderBlock::new);

    public FluidLoaderBlock(BlockBehaviour.Properties properties) {
        super(FluidLoaderBlockEntity.class, properties);
    }

    protected MapCodec<? extends FluidManipulatorBlock<FluidLoaderBlockEntity>> codec() {
        return CODEC;
    }

    @Override
    public Direction getFacing(BlockState blockState) {
        return Direction.DOWN;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new FluidLoaderBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.isClientSide() ? null : FluidLoaderBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.FLUID_LOADER.get()), ManipulatorBlockEntity::serverTick);
    }
}

