/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.manipulator;

import com.mojang.serialization.MapCodec;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.manipulator.ItemLoaderBlockEntity;
import mods.railcraft.world.level.block.entity.manipulator.ManipulatorBlockEntity;
import mods.railcraft.world.level.block.manipulator.ManipulatorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class ItemLoaderBlock
extends ManipulatorBlock<ItemLoaderBlockEntity> {
    private static final MapCodec<ItemLoaderBlock> CODEC = ItemLoaderBlock.simpleCodec(ItemLoaderBlock::new);

    public ItemLoaderBlock(BlockBehaviour.Properties properties) {
        super(ItemLoaderBlockEntity.class, properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends ManipulatorBlock<ItemLoaderBlockEntity>> codec() {
        return CODEC;
    }

    @Override
    public Direction getFacing(BlockState blockState) {
        return Direction.DOWN;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ItemLoaderBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.isClientSide() ? null : ItemLoaderBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.ITEM_LOADER.get()), ManipulatorBlockEntity::serverTick);
    }
}

