/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.manipulator;

import com.mojang.serialization.MapCodec;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.manipulator.TrainDispenserBlockEntity;
import mods.railcraft.world.level.block.manipulator.ManipulatorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import org.jetbrains.annotations.Nullable;

public class TrainDispenserBlock
extends ManipulatorBlock<TrainDispenserBlockEntity> {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    private static final MapCodec<TrainDispenserBlock> CODEC = TrainDispenserBlock.simpleCodec(TrainDispenserBlock::new);

    public TrainDispenserBlock(BlockBehaviour.Properties properties) {
        super(TrainDispenserBlockEntity.class, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(FACING, (Comparable)Direction.DOWN));
    }

    protected MapCodec<? extends ManipulatorBlock<TrainDispenserBlockEntity>> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    @Override
    public Direction getFacing(BlockState blockState) {
        return (Direction)blockState.getValue(FACING);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide() ? null : TrainDispenserBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.TRAIN_DISPENSER.get()), TrainDispenserBlockEntity::serverTick);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TrainDispenserBlockEntity(pos, state);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, @Nullable Orientation orientation, boolean isMoving) {
        boolean flag = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
        level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 4);
        if (level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrainDispenserBlockEntity) {
            TrainDispenserBlockEntity trainDispenserBlockEntity = (TrainDispenserBlockEntity)blockEntity;
            trainDispenserBlockEntity.onNeighborChange();
        }
    }
}

