/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.steamboiler;

import mods.railcraft.world.level.block.steamboiler.SteamBoilerBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class FireboxBlock
extends SteamBoilerBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public FireboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource random) {
        if (((Boolean)blockState.getValue((Property)LIT)).booleanValue()) {
            double x = (double)blockPos.getX() + 0.5;
            double y = (double)blockPos.getY() + 0.4;
            double z = (double)blockPos.getZ() + 0.5;
            if (random.nextDouble() < 0.1) {
                level.playLocalSound(x, y, z, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Direction.Axis axis = direction.getAxis();
                double offset = 0.52;
                double horizontalOffset = random.nextDouble() * 0.6 - 0.3;
                double xOffset = axis == Direction.Axis.X ? (double)direction.getStepX() * offset : horizontalOffset;
                double verticalOffset = random.nextDouble() * 6.0 / 16.0;
                double zOffset = axis == Direction.Axis.Z ? (double)direction.getStepZ() * offset : horizontalOffset;
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x + xOffset, y + verticalOffset, z + zOffset, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, x + xOffset, y + verticalOffset, z + zOffset, 0.0, 0.0, 0.0);
            }
        }
    }
}

