/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track;

import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.attachment.RailcraftAttachmentTypes;
import mods.railcraft.util.BoxBuilder;
import mods.railcraft.util.EntitySearcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ElevatorTrackBlock
extends Block {
    public static final byte ELEVATOR_TIMER = 20;
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    protected static final VoxelShape EAST_SHAPE = ElevatorTrackBlock.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = ElevatorTrackBlock.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = ElevatorTrackBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_SHAPE = ElevatorTrackBlock.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    public static final double FALL_DOWN_CORRECTION = (double)0.04f;
    public static final double RIDE_VELOCITY = 0.4;

    public ElevatorTrackBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED});
    }

    private boolean canAttachTo(BlockGetter world, BlockPos pos, Direction direction) {
        BlockState blockstate = world.getBlockState(pos);
        return blockstate.isFaceSturdy(world, pos, direction);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue(FACING);
        return this.canAttachTo((BlockGetter)world, pos.relative(direction.getOpposite()), direction);
    }

    protected BlockState updateShape(BlockState blockState, LevelReader levelReader, ScheduledTickAccess scheduledTickAccess, BlockPos blockPos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource randomSource) {
        if (direction.getOpposite() == blockState.getValue(FACING) && !blockState.canSurvive(levelReader, blockPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(blockState, levelReader, scheduledTickAccess, blockPos, direction, neighborPos, neighborState, randomSource);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate;
        if (!context.replacingClickedOnBlock() && (blockstate = context.getLevel().getBlockState(context.getClickedPos().relative(context.getClickedFace().getOpposite()))).is((Block)this) && blockstate.getValue(FACING) == context.getClickedFace()) {
            return null;
        }
        BlockState defaultBlockState = this.defaultBlockState();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        for (Direction direction : context.getNearestLookingDirections()) {
            if (!direction.getAxis().isHorizontal() || !(defaultBlockState = (BlockState)defaultBlockState.setValue(FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)level, pos)) continue;
            return defaultBlockState;
        }
        return null;
    }

    public BlockState rotate(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.setValue(FACING, (Comparable)rotation.rotate((Direction)blockState.getValue(FACING)));
    }

    protected BlockState mirror(BlockState blockState, Mirror mirror) {
        return blockState.rotate(mirror.getRotation((Direction)blockState.getValue(FACING)));
    }

    public static boolean getPowered(BlockGetter world, BlockPos pos) {
        return ElevatorTrackBlock.getPowered(world.getBlockState(pos));
    }

    public static boolean getPowered(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> EAST_SHAPE;
        };
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        boolean powered = ElevatorTrackBlock.getPowered(blockState);
        if (powered != this.determinePowered(level, pos, blockState)) {
            level.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(!powered)));
        }
    }

    protected void neighborChanged(BlockState blockState, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean something) {
        super.neighborChanged(blockState, level, pos, neighborBlock, orientation, something);
        boolean powered = ElevatorTrackBlock.getPowered(blockState);
        if (powered != this.determinePowered(level, pos, blockState)) {
            level.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(!powered)));
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier, boolean isInside) {
        entity.fallDistance = 0.0;
        if (level.isClientSide() || !(entity instanceof AbstractMinecart)) {
            return;
        }
        AbstractMinecart abstractMinecart = (AbstractMinecart)entity;
        this.minecartInteraction(level, abstractMinecart, pos);
    }

    protected boolean determinePowered(Level level, BlockPos pos, BlockState state) {
        BlockPos posUp = pos.above();
        BlockState stateUp = level.getBlockState(posUp);
        return level.hasNeighborSignal(pos) || stateUp.is((Block)this) && this.determinePowered(level, posUp, stateUp);
    }

    protected void minecartInteraction(Level level, AbstractMinecart cart, BlockPos pos) {
        RollingStock.getOrThrow(cart).setElevatorRemainingTicks(20);
        cart.setNoGravity(true);
        BlockState state = level.getBlockState(pos);
        this.keepMinecartConnected(pos, state, cart);
        boolean up = ElevatorTrackBlock.getPowered(state);
        boolean hasPath = up ? this.moveUp(level, state, cart, pos) : this.moveDown(level, state, cart, pos);
        if (!hasPath) {
            this.pushMinecartOntoRail(level, pos, state, cart, up);
        }
    }

    private boolean moveUp(Level level, BlockState state, AbstractMinecart cart, BlockPos pos) {
        boolean hasPath;
        BlockPos posUp = pos.above();
        boolean bl = hasPath = level.getBlockState(posUp).is((Block)this) && ElevatorTrackBlock.getPowered((BlockGetter)level, posUp);
        if (hasPath) {
            if (this.isPathEmpty(state, cart, posUp, true)) {
                Vec3 motion = cart.getDeltaMovement();
                cart.setDeltaMovement(motion.x(), 0.4, motion.z());
            } else {
                this.holdPosition(state, cart, pos);
            }
            return true;
        }
        return false;
    }

    private boolean moveDown(Level level, BlockState state, AbstractMinecart cart, BlockPos pos) {
        boolean hasPath;
        BlockPos posDown = pos.below();
        boolean bl = hasPath = level.getBlockState(posDown).is((Block)this) && !ElevatorTrackBlock.getPowered((BlockGetter)level, posDown);
        if (hasPath) {
            if (this.isPathEmpty(state, cart, posDown, false)) {
                Vec3 motion = cart.getDeltaMovement();
                cart.setDeltaMovement(motion.x(), -0.4, motion.z());
            } else {
                this.holdPosition(state, cart, pos);
            }
            return true;
        }
        return false;
    }

    private void holdPosition(BlockState state, AbstractMinecart cart, BlockPos pos) {
        cart.snapTo(cart.getX(), (double)pos.getY() - (double)cart.getBbHeight() / 2.0 + 0.5, cart.getZ(), this.getCartRotation(state, cart), 0.0f);
        cart.setDeltaMovement(cart.getDeltaMovement().multiply(1.0, 0.0, 1.0));
    }

    protected void keepMinecartConnected(BlockPos pos, BlockState state, AbstractMinecart cart) {
        if (BaseRailBlock.isRail((Level)cart.level(), (BlockPos)pos.below()) || BaseRailBlock.isRail((Level)cart.level(), (BlockPos)pos.below(2))) {
            cart.setData(RailcraftAttachmentTypes.CAN_USE_RAIL, (Object)false);
        } else {
            cart.setData(RailcraftAttachmentTypes.CAN_USE_RAIL, (Object)true);
        }
        Vec3 motion = cart.getDeltaMovement();
        cart.setDeltaMovement((double)pos.getX() + 0.5 - cart.getX(), motion.y(), (double)pos.getZ() + 0.5 - cart.getZ());
        this.alignMinecart(state, cart);
    }

    protected void alignMinecart(BlockState state, AbstractMinecart cart) {
        cart.setYRot(this.getCartRotation(state, cart));
    }

    private float getCartRotation(BlockState state, AbstractMinecart cart) {
        return ((Direction)state.getValue(FACING)).getStepY();
    }

    private boolean isPathEmpty(BlockState state, AbstractMinecart cart, BlockPos pos, boolean up) {
        if (cart.level().getBlockState(pos).isSolid()) {
            return false;
        }
        Direction.Axis axis = ((Direction)state.getValue(FACING)).getAxis();
        BoxBuilder factory = BoxBuilder.create().at(pos).expandAxis(axis, 1.0);
        if (up) {
            factory.raiseCeiling(0.5);
            factory.raiseFloor(0.2);
        } else {
            factory.raiseCeiling(-0.2);
            factory.raiseFloor(-0.5);
        }
        return EntitySearcher.findMinecarts().in(factory.build()).except((Entity)cart).list(cart.level()).isEmpty();
    }

    private boolean pushMinecartOntoRail(Level level, BlockPos pos, BlockState state, AbstractMinecart cart, boolean up) {
        cart.setData(RailcraftAttachmentTypes.CAN_USE_RAIL, (Object)true);
        Direction.Axis axis = ((Direction)state.getValue(FACING)).getAxis();
        for (BlockPos target : new BlockPos[]{pos, up ? pos.above() : pos.below()}) {
            for (Direction.AxisDirection direction : Direction.AxisDirection.values()) {
                if (!BaseRailBlock.isRail((Level)level, (BlockPos)target.relative(Direction.get((Direction.AxisDirection)direction, (Direction.Axis)axis)))) continue;
                this.holdPosition(state, cart, target);
                double vel = (double)direction.getStep() * 0.4;
                Vec3 motion = cart.getDeltaMovement();
                if (axis == Direction.Axis.Z) {
                    cart.setDeltaMovement(motion.x(), motion.y(), vel);
                } else {
                    cart.setDeltaMovement(vel, motion.y(), motion.z());
                }
                return true;
            }
        }
        return false;
    }
}

